@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.EncryptionPropertyArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.EncryptionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property keyVaultProperties Key vault properties.
 * @property status Indicates whether or not the encryption is enabled for container registry.
 */
public data class EncryptionPropertyArgs(
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
    public val status: Output<Either<String, EncryptionStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.EncryptionPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.EncryptionPropertyArgs =
        com.pulumi.azurenative.containerregistry.inputs.EncryptionPropertyArgs.builder()
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertyArgs].
 */
@PulumiTagMarker
public class EncryptionPropertyArgsBuilder internal constructor() {
    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    private var status: Output<Either<String, EncryptionStatus>>? = null

    /**
     * @param value Key vault properties.
     */
    @JvmName("ihggianvpniwemxh")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for container registry.
     */
    @JvmName("luvenqeqwbdrpumi")
    public suspend fun status(`value`: Output<Either<String, EncryptionStatus>>) {
        this.status = value
    }

    /**
     * @param value Key vault properties.
     */
    @JvmName("nwvhsyrfxesphssl")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Key vault properties.
     */
    @JvmName("ivqdlvnxkhmrnrww")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for container registry.
     */
    @JvmName("infsgabnykgbkhep")
    public suspend fun status(`value`: Either<String, EncryptionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for container registry.
     */
    @JvmName("orpfvhslbnwxbfsu")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Indicates whether or not the encryption is enabled for container registry.
     */
    @JvmName("csvmciaekipjpond")
    public fun status(`value`: EncryptionStatus) {
        val toBeMapped = Either.ofRight<String, EncryptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): EncryptionPropertyArgs = EncryptionPropertyArgs(
        keyVaultProperties = keyVaultProperties,
        status = status,
    )
}
