@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ExportPolicyArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.ExportPolicyStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The export policy for a container registry.
 * @property status The value that indicates whether the policy is enabled or not.
 */
public data class ExportPolicyArgs(
    public val status: Output<Either<String, ExportPolicyStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ExportPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ExportPolicyArgs =
        com.pulumi.azurenative.containerregistry.inputs.ExportPolicyArgs.builder()
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExportPolicyArgs].
 */
@PulumiTagMarker
public class ExportPolicyArgsBuilder internal constructor() {
    private var status: Output<Either<String, ExportPolicyStatus>>? = null

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("jcgrtilrcajexing")
    public suspend fun status(`value`: Output<Either<String, ExportPolicyStatus>>) {
        this.status = value
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("omxecriclflxfnkj")
    public suspend fun status(`value`: Either<String, ExportPolicyStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("swpfxlogfdkgyxjx")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExportPolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("fjnaewjurbrrvolq")
    public fun status(`value`: ExportPolicyStatus) {
        val toBeMapped = Either.ofRight<String, ExportPolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ExportPolicyArgs = ExportPolicyArgs(
        status = status,
    )
}
