@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val privateEndpointConnectionName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("wwdosxhngmrxtqmv")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("ajhimqhhllksurji")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rvopxafxioooaomg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            registryName = registryName ?: throw PulumiNullFieldException("registryName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
