@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetWebhookCallbackConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property webhookName The name of the webhook.
 */
public data class GetWebhookCallbackConfigPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
    public val webhookName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetWebhookCallbackConfigPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.GetWebhookCallbackConfigPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetWebhookCallbackConfigPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .webhookName(webhookName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebhookCallbackConfigPlainArgs].
 */
@PulumiTagMarker
public class GetWebhookCallbackConfigPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var webhookName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("iydjgnhsurhscmge")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("csdabqlucpeupdda")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("vgldvprtxpetcxrd")
    public suspend fun webhookName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webhookName = mapped
    }

    internal fun build(): GetWebhookCallbackConfigPlainArgs = GetWebhookCallbackConfigPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        webhookName = webhookName ?: throw PulumiNullFieldException("webhookName"),
    )
}
