@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ImportPipelineSourcePropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PipelineSourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the import pipeline source.
 * @property keyVaultUri They key vault secret uri to obtain the source storage SAS token.
 * @property type The type of source for the import pipeline.
 * @property uri The source uri of the import pipeline.
 * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
 * When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
 */
public data class ImportPipelineSourcePropertiesArgs(
    public val keyVaultUri: Output<String>,
    public val type: Output<Either<String, PipelineSourceType>>? = null,
    public val uri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ImportPipelineSourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.ImportPipelineSourcePropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.ImportPipelineSourcePropertiesArgs.builder()
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImportPipelineSourcePropertiesArgs].
 */
@PulumiTagMarker
public class ImportPipelineSourcePropertiesArgsBuilder internal constructor() {
    private var keyVaultUri: Output<String>? = null

    private var type: Output<Either<String, PipelineSourceType>>? = null

    private var uri: Output<String>? = null

    /**
     * @param value They key vault secret uri to obtain the source storage SAS token.
     */
    @JvmName("vtohhlahqwktqxoq")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The type of source for the import pipeline.
     */
    @JvmName("tsdmnpkqpqbilgfp")
    public suspend fun type(`value`: Output<Either<String, PipelineSourceType>>) {
        this.type = value
    }

    /**
     * @param value The source uri of the import pipeline.
     * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     * When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
     */
    @JvmName("teqspruedbgchsde")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value They key vault secret uri to obtain the source storage SAS token.
     */
    @JvmName("uilqbmqmljqiubjs")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The type of source for the import pipeline.
     */
    @JvmName("oytvpdcbkfqsjgct")
    public suspend fun type(`value`: Either<String, PipelineSourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of source for the import pipeline.
     */
    @JvmName("wcufjnabnpeniumi")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PipelineSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of source for the import pipeline.
     */
    @JvmName("mepvugfmumcrptrh")
    public fun type(`value`: PipelineSourceType) {
        val toBeMapped = Either.ofRight<String, PipelineSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The source uri of the import pipeline.
     * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
     * When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
     */
    @JvmName("bekqjiohgabqxmum")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ImportPipelineSourcePropertiesArgs = ImportPipelineSourcePropertiesArgs(
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
        type = type,
        uri = uri,
    )
}
