@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ListTaskRunDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property taskRunName The name of the task run.
 */
public data class ListTaskRunDetailsPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
    public val taskRunName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ListTaskRunDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ListTaskRunDetailsPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.ListTaskRunDetailsPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .taskRunName(taskRunName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListTaskRunDetailsPlainArgs].
 */
@PulumiTagMarker
public class ListTaskRunDetailsPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var taskRunName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("vgacxrjiurutdooc")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("afgcbhnmehiqeiiy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the task run.
     */
    @JvmName("ekoyeutglffgxhxi")
    public suspend fun taskRunName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.taskRunName = mapped
    }

    internal fun build(): ListTaskRunDetailsPlainArgs = ListTaskRunDetailsPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        taskRunName = taskRunName ?: throw PulumiNullFieldException("taskRunName"),
    )
}
