@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.NetworkRuleSetArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.DefaultAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The network rule set for a container registry.
 * @property defaultAction The default action of allow or deny when no other rules match.
 * @property ipRules The IP ACL rules.
 */
public data class NetworkRuleSetArgs(
    public val defaultAction: Output<Either<String, DefaultAction>>,
    public val ipRules: Output<List<IPRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.NetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.NetworkRuleSetArgs =
        com.pulumi.azurenative.containerregistry.inputs.NetworkRuleSetArgs.builder()
            .defaultAction(
                defaultAction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetArgsBuilder internal constructor() {
    private var defaultAction: Output<Either<String, DefaultAction>>? = null

    private var ipRules: Output<List<IPRuleArgs>>? = null

    /**
     * @param value The default action of allow or deny when no other rules match.
     */
    @JvmName("nykterlxonfhagji")
    public suspend fun defaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value The IP ACL rules.
     */
    @JvmName("bgewyulyvjqtidan")
    public suspend fun ipRules(`value`: Output<List<IPRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("rkmpaennfejpcgce")
    public suspend fun ipRules(vararg values: Output<IPRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values The IP ACL rules.
     */
    @JvmName("lybemlykkuxltlrm")
    public suspend fun ipRules(values: List<Output<IPRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value The default action of allow or deny when no other rules match.
     */
    @JvmName("hrkcgaluufxwrinc")
    public suspend fun defaultAction(`value`: Either<String, DefaultAction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action of allow or deny when no other rules match.
     */
    @JvmName("hvpsdrjtuxbyqtyb")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action of allow or deny when no other rules match.
     */
    @JvmName("rmdpaolhnuxbkyfw")
    public fun defaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The IP ACL rules.
     */
    @JvmName("cggdmouhrwqyfypr")
    public suspend fun ipRules(`value`: List<IPRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument The IP ACL rules.
     */
    @JvmName("lviqiqnhjpqyslpy")
    public suspend fun ipRules(argument: List<suspend IPRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The IP ACL rules.
     */
    @JvmName("imdgkqrnrwxjqjux")
    public suspend fun ipRules(vararg argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The IP ACL rules.
     */
    @JvmName("uqtoooluvgklluao")
    public suspend fun ipRules(argument: suspend IPRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values The IP ACL rules.
     */
    @JvmName("fcwbbmltjjayjtvo")
    public suspend fun ipRules(vararg values: IPRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    internal fun build(): NetworkRuleSetArgs = NetworkRuleSetArgs(
        defaultAction = defaultAction ?: throw PulumiNullFieldException("defaultAction"),
        ipRules = ipRules,
    )
}
