@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ParentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of the connected registry parent.
 * @property id The resource ID of the parent to which the connected registry will be associated.
 * @property syncProperties The sync properties of the connected registry with its parent.
 */
public data class ParentPropertiesArgs(
    public val id: Output<String>? = null,
    public val syncProperties: Output<SyncPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ParentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ParentPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.ParentPropertiesArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .syncProperties(
                syncProperties.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ParentPropertiesArgs].
 */
@PulumiTagMarker
public class ParentPropertiesArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var syncProperties: Output<SyncPropertiesArgs>? = null

    /**
     * @param value The resource ID of the parent to which the connected registry will be associated.
     */
    @JvmName("jdolhaoefcpjmwfe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The sync properties of the connected registry with its parent.
     */
    @JvmName("wlcrswjhukhvhwng")
    public suspend fun syncProperties(`value`: Output<SyncPropertiesArgs>) {
        this.syncProperties = value
    }

    /**
     * @param value The resource ID of the parent to which the connected registry will be associated.
     */
    @JvmName("dhjkvsffnmrhspqx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The sync properties of the connected registry with its parent.
     */
    @JvmName("awccphuedwhvywhq")
    public suspend fun syncProperties(`value`: SyncPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncProperties = mapped
    }

    /**
     * @param argument The sync properties of the connected registry with its parent.
     */
    @JvmName("idgwjchqvwytbwtc")
    public suspend fun syncProperties(argument: suspend SyncPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SyncPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.syncProperties = mapped
    }

    internal fun build(): ParentPropertiesArgs = ParentPropertiesArgs(
        id = id,
        syncProperties = syncProperties ?: throw PulumiNullFieldException("syncProperties"),
    )
}
