@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.SourcePropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.SourceControlType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of the source code repository.
 * @property branch The branch name of the source code.
 * @property repositoryUrl The full URL to the source code repository
 * @property sourceControlAuthProperties The authorization properties for accessing the source code repository and to set up
 * webhooks for notifications.
 * @property sourceControlType The type of source control service.
 */
public data class SourcePropertiesArgs(
    public val branch: Output<String>? = null,
    public val repositoryUrl: Output<String>,
    public val sourceControlAuthProperties: Output<AuthInfoArgs>? = null,
    public val sourceControlType: Output<Either<String, SourceControlType>>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.SourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.SourcePropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.SourcePropertiesArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .repositoryUrl(repositoryUrl.applyValue({ args0 -> args0 }))
            .sourceControlAuthProperties(
                sourceControlAuthProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceControlType(
                sourceControlType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [SourcePropertiesArgs].
 */
@PulumiTagMarker
public class SourcePropertiesArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var repositoryUrl: Output<String>? = null

    private var sourceControlAuthProperties: Output<AuthInfoArgs>? = null

    private var sourceControlType: Output<Either<String, SourceControlType>>? = null

    /**
     * @param value The branch name of the source code.
     */
    @JvmName("fiorpkmkrmmdwhgd")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value The full URL to the source code repository
     */
    @JvmName("jjbjvgtwinhqtshn")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value The authorization properties for accessing the source code repository and to set up
     * webhooks for notifications.
     */
    @JvmName("wiovyprrpwgayion")
    public suspend fun sourceControlAuthProperties(`value`: Output<AuthInfoArgs>) {
        this.sourceControlAuthProperties = value
    }

    /**
     * @param value The type of source control service.
     */
    @JvmName("nvrihabrrltggtcp")
    public suspend fun sourceControlType(`value`: Output<Either<String, SourceControlType>>) {
        this.sourceControlType = value
    }

    /**
     * @param value The branch name of the source code.
     */
    @JvmName("cqtwqlnlykanwnis")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value The full URL to the source code repository
     */
    @JvmName("fryqtkhwgwkwwoqr")
    public suspend fun repositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    /**
     * @param value The authorization properties for accessing the source code repository and to set up
     * webhooks for notifications.
     */
    @JvmName("kkjxwecsppfwaqmo")
    public suspend fun sourceControlAuthProperties(`value`: AuthInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceControlAuthProperties = mapped
    }

    /**
     * @param argument The authorization properties for accessing the source code repository and to set up
     * webhooks for notifications.
     */
    @JvmName("xkpiexeplueiwrjq")
    public suspend fun sourceControlAuthProperties(argument: suspend AuthInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AuthInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceControlAuthProperties = mapped
    }

    /**
     * @param value The type of source control service.
     */
    @JvmName("medrpextcbwkdevc")
    public suspend fun sourceControlType(`value`: Either<String, SourceControlType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceControlType = mapped
    }

    /**
     * @param value The type of source control service.
     */
    @JvmName("rffwelyscuepoqoi")
    public fun sourceControlType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceControlType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceControlType = mapped
    }

    /**
     * @param value The type of source control service.
     */
    @JvmName("wjnqofowmmobpqgn")
    public fun sourceControlType(`value`: SourceControlType) {
        val toBeMapped = Either.ofRight<String, SourceControlType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceControlType = mapped
    }

    internal fun build(): SourcePropertiesArgs = SourcePropertiesArgs(
        branch = branch,
        repositoryUrl = repositoryUrl ?: throw PulumiNullFieldException("repositoryUrl"),
        sourceControlAuthProperties = sourceControlAuthProperties,
        sourceControlType = sourceControlType ?: throw PulumiNullFieldException("sourceControlType"),
    )
}
