@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the credentials that will be used to access a custom registry during a run.
 * @property identity Indicates the managed identity assigned to the custom credential. If a user-assigned identity
 * this value is the Client ID. If a system-assigned identity, the value will be `system`. In
 * the case of a system-assigned identity, the Client ID will be determined by the runner. This
 * identity may be used to authenticate to key vault to retrieve credentials or it may be the only
 * source of authentication used for accessing the registry.
 * @property password The password for logging into the custom registry. The password is a secret
 * object that allows multiple ways of providing the value for it.
 * @property userName The username for logging into the custom registry.
 */
public data class CustomRegistryCredentialsResponse(
    public val identity: String? = null,
    public val password: SecretObjectResponse? = null,
    public val userName: SecretObjectResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.CustomRegistryCredentialsResponse):
            CustomRegistryCredentialsResponse = CustomRegistryCredentialsResponse(
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SecretObjectResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userName = javaType.userName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SecretObjectResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
