@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The content of the event request message.
 * @property action The action that encompasses the provided event.
 * @property actor The agent that initiated the event. For most situations, this could be from the authorization context of the request.
 * @property id The event ID.
 * @property request The request that generated the event.
 * @property source The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
 * @property target The target of the event.
 * @property timestamp The time at which the event occurred.
 */
public data class EventContentResponse(
    public val action: String? = null,
    public val actor: ActorResponse? = null,
    public val id: String? = null,
    public val request: RequestResponse? = null,
    public val source: SourceResponse? = null,
    public val target: TargetResponse? = null,
    public val timestamp: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.EventContentResponse):
            EventContentResponse = EventContentResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            actor = javaType.actor().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ActorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            request = javaType.request().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.RequestResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timestamp = javaType.timestamp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
