@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The event for a webhook.
 * @property eventRequestMessage The event request message sent to the service URI.
 * @property eventResponseMessage The event response message received from the service URI.
 * @property id The event ID.
 */
public data class EventResponse(
    public val eventRequestMessage: EventRequestMessageResponse? = null,
    public val eventResponseMessage: EventResponseMessageResponse? = null,
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.EventResponse):
            EventResponse = EventResponse(
            eventRequestMessage = javaType.eventRequestMessage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.EventRequestMessageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventResponseMessage = javaType.eventResponseMessage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.EventResponseMessageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
