@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The configuration of service URI and custom headers for the webhook.
 * @property customHeaders Custom headers that will be added to the webhook notifications.
 * @property serviceUri The service URI for the webhook to post notifications.
 */
public data class GetWebhookCallbackConfigResult(
    public val customHeaders: Map<String, String>? = null,
    public val serviceUri: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetWebhookCallbackConfigResult):
            GetWebhookCallbackConfigResult = GetWebhookCallbackConfigResult(
            customHeaders = javaType.customHeaders().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            serviceUri = javaType.serviceUri(),
        )
    }
}
