@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response from the ListCredentials operation.
 * @property passwords The list of passwords for a container registry.
 * @property username The username for a container registry.
 */
public data class ListRegistryCredentialsResult(
    public val passwords: List<RegistryPasswordResponse>? = null,
    public val username: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ListRegistryCredentialsResult):
            ListRegistryCredentialsResult = ListRegistryCredentialsResult(
            passwords = javaType.passwords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.RegistryPasswordResponse.Companion.toKotlin(args0)
                })
            }),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
