@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the connected registry parent.
 * @property id The resource ID of the parent to which the connected registry will be associated.
 * @property syncProperties The sync properties of the connected registry with its parent.
 */
public data class ParentPropertiesResponse(
    public val id: String? = null,
    public val syncProperties: SyncPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ParentPropertiesResponse):
            ParentPropertiesResponse = ParentPropertiesResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            syncProperties = javaType.syncProperties().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SyncPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
