@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Suppress

/**
 * The policies for a container registry.
 * @property exportPolicy The export policy for a container registry.
 * @property quarantinePolicy The quarantine policy for a container registry.
 * @property retentionPolicy The retention policy for a container registry.
 * @property trustPolicy The content trust policy for a container registry.
 */
public data class PoliciesResponse(
    public val exportPolicy: ExportPolicyResponse? = null,
    public val quarantinePolicy: QuarantinePolicyResponse? = null,
    public val retentionPolicy: RetentionPolicyResponse? = null,
    public val trustPolicy: TrustPolicyResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.PoliciesResponse):
            PoliciesResponse = PoliciesResponse(
            exportPolicy = javaType.exportPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ExportPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            quarantinePolicy = javaType.quarantinePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.QuarantinePolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.RetentionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trustPolicy = javaType.trustPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TrustPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
