@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Run resource properties
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property createTime The time the run was scheduled.
 * @property customRegistries The list of custom registries that were logged in during this run.
 * @property finishTime The time the run finished.
 * @property id The resource ID.
 * @property imageUpdateTrigger The image update trigger that caused the run. This is applicable if the task has base image trigger configured.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled or not.
 * @property lastUpdatedTime The last updated time for the run.
 * @property logArtifact The image description for the log artifact.
 * @property name The name of the resource.
 * @property outputImages The list of all images that were generated from the run. This is applicable if the run generates base image dependencies.
 * @property platform The platform properties against which the run will happen.
 * @property provisioningState The provisioning state of a run.
 * @property runErrorMessage The error message received from backend systems after the run is scheduled.
 * @property runId The unique identifier for the run.
 * @property runType The type of run.
 * @property sourceRegistryAuth The scope of the credentials that were used to login to the source registry during this run.
 * @property sourceTrigger The source trigger that caused the run.
 * @property startTime The time the run started.
 * @property status The current status of the run.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property task The task against which run was scheduled.
 * @property timerTrigger The timer trigger that caused the run.
 * @property type The type of the resource.
 * @property updateTriggerToken The update trigger token passed for the Run.
 */
public data class RunResponse(
    public val agentConfiguration: AgentPropertiesResponse? = null,
    public val agentPoolName: String? = null,
    public val createTime: String? = null,
    public val customRegistries: List<String>? = null,
    public val finishTime: String? = null,
    public val id: String,
    public val imageUpdateTrigger: ImageUpdateTriggerResponse? = null,
    public val isArchiveEnabled: Boolean? = null,
    public val lastUpdatedTime: String? = null,
    public val logArtifact: ImageDescriptorResponse,
    public val name: String,
    public val outputImages: List<ImageDescriptorResponse>? = null,
    public val platform: PlatformPropertiesResponse? = null,
    public val provisioningState: String? = null,
    public val runErrorMessage: String,
    public val runId: String? = null,
    public val runType: String? = null,
    public val sourceRegistryAuth: String? = null,
    public val sourceTrigger: SourceTriggerDescriptorResponse? = null,
    public val startTime: String? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val task: String? = null,
    public val timerTrigger: TimerTriggerDescriptorResponse? = null,
    public val type: String,
    public val updateTriggerToken: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.RunResponse):
            RunResponse = RunResponse(
            agentConfiguration = javaType.agentConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.AgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentPoolName = javaType.agentPoolName().map({ args0 -> args0 }).orElse(null),
            createTime = javaType.createTime().map({ args0 -> args0 }).orElse(null),
            customRegistries = javaType.customRegistries().map({ args0 -> args0 }),
            finishTime = javaType.finishTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            imageUpdateTrigger = javaType.imageUpdateTrigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ImageUpdateTriggerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isArchiveEnabled = javaType.isArchiveEnabled().map({ args0 -> args0 }).orElse(null),
            lastUpdatedTime = javaType.lastUpdatedTime().map({ args0 -> args0 }).orElse(null),
            logArtifact = javaType.logArtifact().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.ImageDescriptorResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            outputImages = javaType.outputImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ImageDescriptorResponse.Companion.toKotlin(args0)
                })
            }),
            platform = javaType.platform().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PlatformPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            runErrorMessage = javaType.runErrorMessage(),
            runId = javaType.runId().map({ args0 -> args0 }).orElse(null),
            runType = javaType.runType().map({ args0 -> args0 }).orElse(null),
            sourceRegistryAuth = javaType.sourceRegistryAuth().map({ args0 -> args0 }).orElse(null),
            sourceTrigger = javaType.sourceTrigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SourceTriggerDescriptorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            task = javaType.task().map({ args0 -> args0 }).orElse(null),
            timerTrigger = javaType.timerTrigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TimerTriggerDescriptorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            updateTriggerToken = javaType.updateTriggerToken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
