@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SKU of a container registry.
 * @property name The SKU name of the container registry. Required for registry creation.
 * @property tier The SKU tier based on the SKU name.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier(),
        )
    }
}
