@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a source based trigger.
 * @property name The name of the trigger.
 * @property sourceRepository The properties that describes the source(code) for the task.
 * @property sourceTriggerEvents The source event corresponding to the trigger.
 * @property status The current status of trigger.
 */
public data class SourceTriggerResponse(
    public val name: String,
    public val sourceRepository: SourcePropertiesResponse,
    public val sourceTriggerEvents: List<String>,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SourceTriggerResponse):
            SourceTriggerResponse = SourceTriggerResponse(
            name = javaType.name(),
            sourceRepository = javaType.sourceRepository().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SourcePropertiesResponse.Companion.toKotlin(args0)
            }),
            sourceTriggerEvents = javaType.sourceTriggerEvents().map({ args0 -> args0 }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
