@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The TLS properties of the connected registry login server.
 * @property certificate The certificate used to configure HTTPS for the login server.
 * @property status Indicates whether HTTPS is enabled for the login server.
 */
public data class TlsPropertiesResponse(
    public val certificate: TlsCertificatePropertiesResponse,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TlsPropertiesResponse):
            TlsPropertiesResponse = TlsPropertiesResponse(
            certificate = javaType.certificate().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.TlsCertificatePropertiesResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status(),
        )
    }
}
