@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The content trust policy for a container registry.
 * @property status The value that indicates whether the policy is enabled or not.
 * @property type The type of trust policy.
 */
public data class TrustPolicyResponse(
    public val status: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TrustPolicyResponse):
            TrustPolicyResponse = TrustPolicyResponse(
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
