@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.AgentPoolArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.AgentPoolMode
import com.pulumi.azurenative.containerservice.kotlin.enums.AgentPoolType
import com.pulumi.azurenative.containerservice.kotlin.enums.GPUInstanceProfile
import com.pulumi.azurenative.containerservice.kotlin.enums.KubeletDiskType
import com.pulumi.azurenative.containerservice.kotlin.enums.OSDiskType
import com.pulumi.azurenative.containerservice.kotlin.enums.OSSKU
import com.pulumi.azurenative.containerservice.kotlin.enums.OSType
import com.pulumi.azurenative.containerservice.kotlin.enums.ScaleDownMode
import com.pulumi.azurenative.containerservice.kotlin.enums.ScaleSetEvictionPolicy
import com.pulumi.azurenative.containerservice.kotlin.enums.ScaleSetPriority
import com.pulumi.azurenative.containerservice.kotlin.enums.WorkloadRuntime
import com.pulumi.azurenative.containerservice.kotlin.inputs.AgentPoolUpgradeSettingsArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.AgentPoolUpgradeSettingsArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.CreationDataArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.CreationDataArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.KubeletConfigArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.KubeletConfigArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.LinuxOSConfigArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.LinuxOSConfigArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.PowerStateArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.PowerStateArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Agent Pool.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-02-01, 2019-04-01, 2020-06-01, 2021-02-01, 2021-08-01, 2022-04-02-preview, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview.
 * ## Example Usage
 * ### Create Agent Pool using an agent pool snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *         {
 *             SourceResourceId = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1",
 *         },
 *         EnableFIPS = true,
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			CreationData: &containerservice.CreationDataArgs{
 * 				SourceResourceId: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
 * 			},
 * 			EnableFIPS:          pulumi.Bool(true),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .creationData(Map.of("sourceResourceId", "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"))
 *             .enableFIPS(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Dedicated Host Group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         HostGroupID = "/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1",
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			HostGroupID:         pulumi.String("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .hostGroupID("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with EncryptionAtHost enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableEncryptionAtHost = true,
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:          pulumi.String("agentpool1"),
 * 			Count:                  pulumi.Int(3),
 * 			EnableEncryptionAtHost: pulumi.Bool(true),
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String("Linux"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			VmSize:                 pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableEncryptionAtHost(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Ephemeral OS Disk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         OrchestratorVersion = "",
 *         OsDiskSizeGB = 64,
 *         OsDiskType = "Ephemeral",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsDiskSizeGB:        pulumi.Int(64),
 * 			OsDiskType:          pulumi.String("Ephemeral"),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .orchestratorVersion("")
 *             .osDiskSizeGB(64)
 *             .osDiskType("Ephemeral")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with FIPS enabled OS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableFIPS = true,
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			EnableFIPS:          pulumi.Bool(true),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableFIPS(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with GPUMIG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         GpuInstanceProfile = "MIG2g",
 *         KubeletConfig = new AzureNative.ContainerService.Inputs.KubeletConfigArgs
 *         {
 *             AllowedUnsafeSysctls = new[]
 *             {
 *                 "kernel.msg*",
 *                 "net.core.somaxconn",
 *             },
 *             CpuCfsQuota = true,
 *             CpuCfsQuotaPeriod = "200ms",
 *             CpuManagerPolicy = "static",
 *             FailSwapOn = false,
 *             ImageGcHighThreshold = 90,
 *             ImageGcLowThreshold = 70,
 *             TopologyManagerPolicy = "best-effort",
 *         },
 *         LinuxOSConfig = new AzureNative.ContainerService.Inputs.LinuxOSConfigArgs
 *         {
 *             SwapFileSizeMB = 1500,
 *             Sysctls = new AzureNative.ContainerService.Inputs.SysctlConfigArgs
 *             {
 *                 KernelThreadsMax = 99999,
 *                 NetCoreWmemDefault = 12345,
 *                 NetIpv4IpLocalPortRange = "20000 60000",
 *                 NetIpv4TcpTwReuse = true,
 *             },
 *             TransparentHugePageDefrag = "madvise",
 *             TransparentHugePageEnabled = "always",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_ND96asr_v4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:      pulumi.String("agentpool1"),
 * 			Count:              pulumi.Int(3),
 * 			GpuInstanceProfile: pulumi.String("MIG2g"),
 * 			KubeletConfig: &containerservice.KubeletConfigArgs{
 * 				AllowedUnsafeSysctls: pulumi.StringArray{
 * 					pulumi.String("kernel.msg*"),
 * 					pulumi.String("net.core.somaxconn"),
 * 				},
 * 				CpuCfsQuota:           pulumi.Bool(true),
 * 				CpuCfsQuotaPeriod:     pulumi.String("200ms"),
 * 				CpuManagerPolicy:      pulumi.String("static"),
 * 				FailSwapOn:            pulumi.Bool(false),
 * 				ImageGcHighThreshold:  pulumi.Int(90),
 * 				ImageGcLowThreshold:   pulumi.Int(70),
 * 				TopologyManagerPolicy: pulumi.String("best-effort"),
 * 			},
 * 			LinuxOSConfig: containerservice.LinuxOSConfigResponse{
 * 				SwapFileSizeMB: pulumi.Int(1500),
 * 				Sysctls: &containerservice.SysctlConfigArgs{
 * 					KernelThreadsMax:        pulumi.Int(99999),
 * 					NetCoreWmemDefault:      pulumi.Int(12345),
 * 					NetIpv4IpLocalPortRange: pulumi.String("20000 60000"),
 * 					NetIpv4TcpTwReuse:       pulumi.Bool(true),
 * 				},
 * 				TransparentHugePageDefrag:  pulumi.String("madvise"),
 * 				TransparentHugePageEnabled: pulumi.String("always"),
 * 			},
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_ND96asr_v4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .gpuInstanceProfile("MIG2g")
 *             .kubeletConfig(Map.ofEntries(
 *                 Map.entry("allowedUnsafeSysctls",
 *                     "kernel.msg*",
 *                     "net.core.somaxconn"),
 *                 Map.entry("cpuCfsQuota", true),
 *                 Map.entry("cpuCfsQuotaPeriod", "200ms"),
 *                 Map.entry("cpuManagerPolicy", "static"),
 *                 Map.entry("failSwapOn", false),
 *                 Map.entry("imageGcHighThreshold", 90),
 *                 Map.entry("imageGcLowThreshold", 70),
 *                 Map.entry("topologyManagerPolicy", "best-effort")
 *             ))
 *             .linuxOSConfig(Map.ofEntries(
 *                 Map.entry("swapFileSizeMB", 1500),
 *                 Map.entry("sysctls", Map.ofEntries(
 *                     Map.entry("kernelThreadsMax", 99999),
 *                     Map.entry("netCoreWmemDefault", 12345),
 *                     Map.entry("netIpv4IpLocalPortRange", "20000 60000"),
 *                     Map.entry("netIpv4TcpTwReuse", true)
 *                 )),
 *                 Map.entry("transparentHugePageDefrag", "madvise"),
 *                 Map.entry("transparentHugePageEnabled", "always")
 *             ))
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_ND96asr_v4")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Krustlet and the WASI runtime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         Mode = "User",
 *         OrchestratorVersion = "",
 *         OsDiskSizeGB = 64,
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *         WorkloadRuntime = "WasmWasi",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			Mode:                pulumi.String("User"),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsDiskSizeGB:        pulumi.Int(64),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 			WorkloadRuntime:     pulumi.String("WasmWasi"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .mode("User")
 *             .orchestratorVersion("")
 *             .osDiskSizeGB(64)
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .workloadRuntime("WasmWasi")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with KubeletConfig and LinuxOSConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         KubeletConfig = new AzureNative.ContainerService.Inputs.KubeletConfigArgs
 *         {
 *             AllowedUnsafeSysctls = new[]
 *             {
 *                 "kernel.msg*",
 *                 "net.core.somaxconn",
 *             },
 *             CpuCfsQuota = true,
 *             CpuCfsQuotaPeriod = "200ms",
 *             CpuManagerPolicy = "static",
 *             FailSwapOn = false,
 *             ImageGcHighThreshold = 90,
 *             ImageGcLowThreshold = 70,
 *             TopologyManagerPolicy = "best-effort",
 *         },
 *         LinuxOSConfig = new AzureNative.ContainerService.Inputs.LinuxOSConfigArgs
 *         {
 *             SwapFileSizeMB = 1500,
 *             Sysctls = new AzureNative.ContainerService.Inputs.SysctlConfigArgs
 *             {
 *                 KernelThreadsMax = 99999,
 *                 NetCoreWmemDefault = 12345,
 *                 NetIpv4IpLocalPortRange = "20000 60000",
 *                 NetIpv4TcpTwReuse = true,
 *             },
 *             TransparentHugePageDefrag = "madvise",
 *             TransparentHugePageEnabled = "always",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			KubeletConfig: &containerservice.KubeletConfigArgs{
 * 				AllowedUnsafeSysctls: pulumi.StringArray{
 * 					pulumi.String("kernel.msg*"),
 * 					pulumi.String("net.core.somaxconn"),
 * 				},
 * 				CpuCfsQuota:           pulumi.Bool(true),
 * 				CpuCfsQuotaPeriod:     pulumi.String("200ms"),
 * 				CpuManagerPolicy:      pulumi.String("static"),
 * 				FailSwapOn:            pulumi.Bool(false),
 * 				ImageGcHighThreshold:  pulumi.Int(90),
 * 				ImageGcLowThreshold:   pulumi.Int(70),
 * 				TopologyManagerPolicy: pulumi.String("best-effort"),
 * 			},
 * 			LinuxOSConfig: containerservice.LinuxOSConfigResponse{
 * 				SwapFileSizeMB: pulumi.Int(1500),
 * 				Sysctls: &containerservice.SysctlConfigArgs{
 * 					KernelThreadsMax:        pulumi.Int(99999),
 * 					NetCoreWmemDefault:      pulumi.Int(12345),
 * 					NetIpv4IpLocalPortRange: pulumi.String("20000 60000"),
 * 					NetIpv4TcpTwReuse:       pulumi.Bool(true),
 * 				},
 * 				TransparentHugePageDefrag:  pulumi.String("madvise"),
 * 				TransparentHugePageEnabled: pulumi.String("always"),
 * 			},
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .kubeletConfig(Map.ofEntries(
 *                 Map.entry("allowedUnsafeSysctls",
 *                     "kernel.msg*",
 *                     "net.core.somaxconn"),
 *                 Map.entry("cpuCfsQuota", true),
 *                 Map.entry("cpuCfsQuotaPeriod", "200ms"),
 *                 Map.entry("cpuManagerPolicy", "static"),
 *                 Map.entry("failSwapOn", false),
 *                 Map.entry("imageGcHighThreshold", 90),
 *                 Map.entry("imageGcLowThreshold", 70),
 *                 Map.entry("topologyManagerPolicy", "best-effort")
 *             ))
 *             .linuxOSConfig(Map.ofEntries(
 *                 Map.entry("swapFileSizeMB", 1500),
 *                 Map.entry("sysctls", Map.ofEntries(
 *                     Map.entry("kernelThreadsMax", 99999),
 *                     Map.entry("netCoreWmemDefault", 12345),
 *                     Map.entry("netIpv4IpLocalPortRange", "20000 60000"),
 *                     Map.entry("netIpv4TcpTwReuse", true)
 *                 )),
 *                 Map.entry("transparentHugePageDefrag", "madvise"),
 *                 Map.entry("transparentHugePageEnabled", "always")
 *             ))
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with OSSKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         KubeletConfig = new AzureNative.ContainerService.Inputs.KubeletConfigArgs
 *         {
 *             AllowedUnsafeSysctls = new[]
 *             {
 *                 "kernel.msg*",
 *                 "net.core.somaxconn",
 *             },
 *             CpuCfsQuota = true,
 *             CpuCfsQuotaPeriod = "200ms",
 *             CpuManagerPolicy = "static",
 *             FailSwapOn = false,
 *             ImageGcHighThreshold = 90,
 *             ImageGcLowThreshold = 70,
 *             TopologyManagerPolicy = "best-effort",
 *         },
 *         LinuxOSConfig = new AzureNative.ContainerService.Inputs.LinuxOSConfigArgs
 *         {
 *             SwapFileSizeMB = 1500,
 *             Sysctls = new AzureNative.ContainerService.Inputs.SysctlConfigArgs
 *             {
 *                 KernelThreadsMax = 99999,
 *                 NetCoreWmemDefault = 12345,
 *                 NetIpv4IpLocalPortRange = "20000 60000",
 *                 NetIpv4TcpTwReuse = true,
 *             },
 *             TransparentHugePageDefrag = "madvise",
 *             TransparentHugePageEnabled = "always",
 *         },
 *         OrchestratorVersion = "",
 *         OsSKU = "AzureLinux",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			KubeletConfig: &containerservice.KubeletConfigArgs{
 * 				AllowedUnsafeSysctls: pulumi.StringArray{
 * 					pulumi.String("kernel.msg*"),
 * 					pulumi.String("net.core.somaxconn"),
 * 				},
 * 				CpuCfsQuota:           pulumi.Bool(true),
 * 				CpuCfsQuotaPeriod:     pulumi.String("200ms"),
 * 				CpuManagerPolicy:      pulumi.String("static"),
 * 				FailSwapOn:            pulumi.Bool(false),
 * 				ImageGcHighThreshold:  pulumi.Int(90),
 * 				ImageGcLowThreshold:   pulumi.Int(70),
 * 				TopologyManagerPolicy: pulumi.String("best-effort"),
 * 			},
 * 			LinuxOSConfig: containerservice.LinuxOSConfigResponse{
 * 				SwapFileSizeMB: pulumi.Int(1500),
 * 				Sysctls: &containerservice.SysctlConfigArgs{
 * 					KernelThreadsMax:        pulumi.Int(99999),
 * 					NetCoreWmemDefault:      pulumi.Int(12345),
 * 					NetIpv4IpLocalPortRange: pulumi.String("20000 60000"),
 * 					NetIpv4TcpTwReuse:       pulumi.Bool(true),
 * 				},
 * 				TransparentHugePageDefrag:  pulumi.String("madvise"),
 * 				TransparentHugePageEnabled: pulumi.String("always"),
 * 			},
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsSKU:               pulumi.String("AzureLinux"),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .kubeletConfig(Map.ofEntries(
 *                 Map.entry("allowedUnsafeSysctls",
 *                     "kernel.msg*",
 *                     "net.core.somaxconn"),
 *                 Map.entry("cpuCfsQuota", true),
 *                 Map.entry("cpuCfsQuotaPeriod", "200ms"),
 *                 Map.entry("cpuManagerPolicy", "static"),
 *                 Map.entry("failSwapOn", false),
 *                 Map.entry("imageGcHighThreshold", 90),
 *                 Map.entry("imageGcLowThreshold", 70),
 *                 Map.entry("topologyManagerPolicy", "best-effort")
 *             ))
 *             .linuxOSConfig(Map.ofEntries(
 *                 Map.entry("swapFileSizeMB", 1500),
 *                 Map.entry("sysctls", Map.ofEntries(
 *                     Map.entry("kernelThreadsMax", 99999),
 *                     Map.entry("netCoreWmemDefault", 12345),
 *                     Map.entry("netIpv4IpLocalPortRange", "20000 60000"),
 *                     Map.entry("netIpv4TcpTwReuse", true)
 *                 )),
 *                 Map.entry("transparentHugePageDefrag", "madvise"),
 *                 Map.entry("transparentHugePageEnabled", "always")
 *             ))
 *             .orchestratorVersion("")
 *             .osSKU("AzureLinux")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with PPG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ProximityPlacementGroupID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:             pulumi.String("agentpool1"),
 * 			Count:                     pulumi.Int(3),
 * 			OrchestratorVersion:       pulumi.String(""),
 * 			OsType:                    pulumi.String("Linux"),
 * 			ProximityPlacementGroupID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			ResourceName:              pulumi.String("clustername1"),
 * 			VmSize:                    pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .proximityPlacementGroupID("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with UltraSSD enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableUltraSSD = true,
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			EnableUltraSSD:      pulumi.Bool(true),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String("Linux"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableUltraSSD(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Windows OSSKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "wnp2",
 *         Count = 3,
 *         OrchestratorVersion = "1.23.3",
 *         OsSKU = "Windows2022",
 *         OsType = "Windows",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_D4s_v3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("wnp2"),
 * 			Count:               pulumi.Int(3),
 * 			OrchestratorVersion: pulumi.String("1.23.3"),
 * 			OsSKU:               pulumi.String("Windows2022"),
 * 			OsType:              pulumi.String("Windows"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_D4s_v3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("wnp2")
 *             .count(3)
 *             .orchestratorVersion("1.23.3")
 *             .osSKU("Windows2022")
 *             .osType("Windows")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_D4s_v3")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Spot Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         NodeLabels =
 *         {
 *             { "key1", "val1" },
 *         },
 *         NodeTaints = new[]
 *         {
 *             "Key1=Value1:NoSchedule",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ScaleSetEvictionPolicy = "Delete",
 *         ScaleSetPriority = "Spot",
 *         Tags =
 *         {
 *             { "name1", "val1" },
 *         },
 *         VmSize = "Standard_DS1_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			NodeLabels: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 			NodeTaints: pulumi.StringArray{
 * 				pulumi.String("Key1=Value1:NoSchedule"),
 * 			},
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String("Linux"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			ScaleSetEvictionPolicy: pulumi.String("Delete"),
 * 			ScaleSetPriority:       pulumi.String("Spot"),
 * 			Tags: pulumi.StringMap{
 * 				"name1": pulumi.String("val1"),
 * 			},
 * 			VmSize: pulumi.String("Standard_DS1_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .nodeLabels(Map.of("key1", "val1"))
 *             .nodeTaints("Key1=Value1:NoSchedule")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .scaleSetEvictionPolicy("Delete")
 *             .scaleSetPriority("Spot")
 *             .tags(Map.of("name1", "val1"))
 *             .vmSize("Standard_DS1_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create/Update Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         Mode = "User",
 *         NodeLabels =
 *         {
 *             { "key1", "val1" },
 *         },
 *         NodeTaints = new[]
 *         {
 *             "Key1=Value1:NoSchedule",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ScaleSetEvictionPolicy = "Delete",
 *         ScaleSetPriority = "Spot",
 *         Tags =
 *         {
 *             { "name1", "val1" },
 *         },
 *         VmSize = "Standard_DS1_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			Mode:          pulumi.String("User"),
 * 			NodeLabels: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 			NodeTaints: pulumi.StringArray{
 * 				pulumi.String("Key1=Value1:NoSchedule"),
 * 			},
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String("Linux"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			ScaleSetEvictionPolicy: pulumi.String("Delete"),
 * 			ScaleSetPriority:       pulumi.String("Spot"),
 * 			Tags: pulumi.StringMap{
 * 				"name1": pulumi.String("val1"),
 * 			},
 * 			VmSize: pulumi.String("Standard_DS1_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .mode("User")
 *             .nodeLabels(Map.of("key1", "val1"))
 *             .nodeTaints("Key1=Value1:NoSchedule")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .scaleSetEvictionPolicy("Delete")
 *             .scaleSetPriority("Spot")
 *             .tags(Map.of("name1", "val1"))
 *             .vmSize("Standard_DS1_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Start Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         PowerState = new AzureNative.ContainerService.Inputs.PowerStateArgs
 *         {
 *             Code = "Running",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			PowerState: &containerservice.PowerStateArgs{
 * 				Code: pulumi.String("Running"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .powerState(Map.of("code", "Running"))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .build());
 *     }
 * }
 * ```
 * ### Stop Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         PowerState = new AzureNative.ContainerService.Inputs.PowerStateArgs
 *         {
 *             Code = "Stopped",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			PowerState: &containerservice.PowerStateArgs{
 * 				Code: pulumi.String("Stopped"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .powerState(Map.of("code", "Stopped"))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .build());
 *     }
 * }
 * ```
 * ### Update Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableAutoScaling = true,
 *         MaxCount = 2,
 *         MinCount = 2,
 *         NodeTaints = new[]
 *         {
 *             "Key1=Value1:NoSchedule",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = "Linux",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ScaleSetEvictionPolicy = "Delete",
 *         ScaleSetPriority = "Spot",
 *         VmSize = "Standard_DS1_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:     pulumi.String("agentpool1"),
 * 			Count:             pulumi.Int(3),
 * 			EnableAutoScaling: pulumi.Bool(true),
 * 			MaxCount:          pulumi.Int(2),
 * 			MinCount:          pulumi.Int(2),
 * 			NodeTaints: pulumi.StringArray{
 * 				pulumi.String("Key1=Value1:NoSchedule"),
 * 			},
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String("Linux"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			ScaleSetEvictionPolicy: pulumi.String("Delete"),
 * 			ScaleSetPriority:       pulumi.String("Spot"),
 * 			VmSize:                 pulumi.String("Standard_DS1_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableAutoScaling(true)
 *             .maxCount(2)
 *             .minCount(2)
 *             .nodeTaints("Key1=Value1:NoSchedule")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .scaleSetEvictionPolicy("Delete")
 *             .scaleSetPriority("Spot")
 *             .vmSize("Standard_DS1_v2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:AgentPool agentpool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}
 * ```
 * @property agentPoolName The name of the agent pool.
 * @property availabilityZones The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
 * @property count Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
 * @property creationData CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
 * @property enableAutoScaling Whether to enable auto-scaler
 * @property enableEncryptionAtHost This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
 * @property enableFIPS See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
 * @property enableNodePublicIP Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
 * @property enableUltraSSD Whether to enable UltraSSD
 * @property gpuInstanceProfile GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
 * @property hostGroupID This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
 * @property kubeletConfig The Kubelet configuration on the agent pool nodes.
 * @property kubeletDiskType Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
 * @property linuxOSConfig The OS configuration of Linux agent nodes.
 * @property maxCount The maximum number of nodes for auto-scaling
 * @property maxPods The maximum number of pods that can run on a node.
 * @property minCount The minimum number of nodes for auto-scaling
 * @property mode A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
 * @property nodeLabels The node labels to be persisted across all nodes in agent pool.
 * @property nodePublicIPPrefixID This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
 * @property nodeTaints The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
 * @property orchestratorVersion Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
 * @property osDiskSizeGB OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
 * @property osDiskType The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
 * @property osSKU Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
 * @property osType The operating system type. The default is Linux.
 * @property podSubnetID If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
 * @property powerState When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
 * @property proximityPlacementGroupID The ID for Proximity Placement Group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property scaleDownMode This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
 * @property scaleSetEvictionPolicy This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
 * @property scaleSetPriority The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
 * @property spotMaxPrice Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
 * @property tags The tags to be persisted on the agent pool virtual machine scale set.
 * @property type The type of Agent Pool.
 * @property upgradeSettings Settings for upgrading the agentpool
 * @property vmSize VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
 * @property vnetSubnetID If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
 * @property workloadRuntime Determines the type of workload a node can run.
 */
public data class AgentPoolArgs(
    public val agentPoolName: Output<String>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val count: Output<Int>? = null,
    public val creationData: Output<CreationDataArgs>? = null,
    public val enableAutoScaling: Output<Boolean>? = null,
    public val enableEncryptionAtHost: Output<Boolean>? = null,
    public val enableFIPS: Output<Boolean>? = null,
    public val enableNodePublicIP: Output<Boolean>? = null,
    public val enableUltraSSD: Output<Boolean>? = null,
    public val gpuInstanceProfile: Output<Either<String, GPUInstanceProfile>>? = null,
    public val hostGroupID: Output<String>? = null,
    public val kubeletConfig: Output<KubeletConfigArgs>? = null,
    public val kubeletDiskType: Output<Either<String, KubeletDiskType>>? = null,
    public val linuxOSConfig: Output<LinuxOSConfigArgs>? = null,
    public val maxCount: Output<Int>? = null,
    public val maxPods: Output<Int>? = null,
    public val minCount: Output<Int>? = null,
    public val mode: Output<Either<String, AgentPoolMode>>? = null,
    public val nodeLabels: Output<Map<String, String>>? = null,
    public val nodePublicIPPrefixID: Output<String>? = null,
    public val nodeTaints: Output<List<String>>? = null,
    public val orchestratorVersion: Output<String>? = null,
    public val osDiskSizeGB: Output<Int>? = null,
    public val osDiskType: Output<Either<String, OSDiskType>>? = null,
    public val osSKU: Output<Either<String, OSSKU>>? = null,
    public val osType: Output<Either<String, OSType>>? = null,
    public val podSubnetID: Output<String>? = null,
    public val powerState: Output<PowerStateArgs>? = null,
    public val proximityPlacementGroupID: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val scaleDownMode: Output<Either<String, ScaleDownMode>>? = null,
    public val scaleSetEvictionPolicy: Output<Either<String, ScaleSetEvictionPolicy>>? = null,
    public val scaleSetPriority: Output<Either<String, ScaleSetPriority>>? = null,
    public val spotMaxPrice: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<Either<String, AgentPoolType>>? = null,
    public val upgradeSettings: Output<AgentPoolUpgradeSettingsArgs>? = null,
    public val vmSize: Output<String>? = null,
    public val vnetSubnetID: Output<String>? = null,
    public val workloadRuntime: Output<Either<String, WorkloadRuntime>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.AgentPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.AgentPoolArgs =
        com.pulumi.azurenative.containerservice.AgentPoolArgs.builder()
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .count(count?.applyValue({ args0 -> args0 }))
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableAutoScaling(enableAutoScaling?.applyValue({ args0 -> args0 }))
            .enableEncryptionAtHost(enableEncryptionAtHost?.applyValue({ args0 -> args0 }))
            .enableFIPS(enableFIPS?.applyValue({ args0 -> args0 }))
            .enableNodePublicIP(enableNodePublicIP?.applyValue({ args0 -> args0 }))
            .enableUltraSSD(enableUltraSSD?.applyValue({ args0 -> args0 }))
            .gpuInstanceProfile(
                gpuInstanceProfile?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .hostGroupID(hostGroupID?.applyValue({ args0 -> args0 }))
            .kubeletConfig(kubeletConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kubeletDiskType(
                kubeletDiskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .linuxOSConfig(linuxOSConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxCount(maxCount?.applyValue({ args0 -> args0 }))
            .maxPods(maxPods?.applyValue({ args0 -> args0 }))
            .minCount(minCount?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nodeLabels(
                nodeLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .nodePublicIPPrefixID(nodePublicIPPrefixID?.applyValue({ args0 -> args0 }))
            .nodeTaints(nodeTaints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .orchestratorVersion(orchestratorVersion?.applyValue({ args0 -> args0 }))
            .osDiskSizeGB(osDiskSizeGB?.applyValue({ args0 -> args0 }))
            .osDiskType(
                osDiskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .osSKU(
                osSKU?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .podSubnetID(podSubnetID?.applyValue({ args0 -> args0 }))
            .powerState(powerState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .proximityPlacementGroupID(proximityPlacementGroupID?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .scaleDownMode(
                scaleDownMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scaleSetEvictionPolicy(
                scaleSetEvictionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .scaleSetPriority(
                scaleSetPriority?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .spotMaxPrice(spotMaxPrice?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .upgradeSettings(upgradeSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmSize(vmSize?.applyValue({ args0 -> args0 }))
            .vnetSubnetID(vnetSubnetID?.applyValue({ args0 -> args0 }))
            .workloadRuntime(
                workloadRuntime?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AgentPoolArgs].
 */
@PulumiTagMarker
public class AgentPoolArgsBuilder internal constructor() {
    private var agentPoolName: Output<String>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var count: Output<Int>? = null

    private var creationData: Output<CreationDataArgs>? = null

    private var enableAutoScaling: Output<Boolean>? = null

    private var enableEncryptionAtHost: Output<Boolean>? = null

    private var enableFIPS: Output<Boolean>? = null

    private var enableNodePublicIP: Output<Boolean>? = null

    private var enableUltraSSD: Output<Boolean>? = null

    private var gpuInstanceProfile: Output<Either<String, GPUInstanceProfile>>? = null

    private var hostGroupID: Output<String>? = null

    private var kubeletConfig: Output<KubeletConfigArgs>? = null

    private var kubeletDiskType: Output<Either<String, KubeletDiskType>>? = null

    private var linuxOSConfig: Output<LinuxOSConfigArgs>? = null

    private var maxCount: Output<Int>? = null

    private var maxPods: Output<Int>? = null

    private var minCount: Output<Int>? = null

    private var mode: Output<Either<String, AgentPoolMode>>? = null

    private var nodeLabels: Output<Map<String, String>>? = null

    private var nodePublicIPPrefixID: Output<String>? = null

    private var nodeTaints: Output<List<String>>? = null

    private var orchestratorVersion: Output<String>? = null

    private var osDiskSizeGB: Output<Int>? = null

    private var osDiskType: Output<Either<String, OSDiskType>>? = null

    private var osSKU: Output<Either<String, OSSKU>>? = null

    private var osType: Output<Either<String, OSType>>? = null

    private var podSubnetID: Output<String>? = null

    private var powerState: Output<PowerStateArgs>? = null

    private var proximityPlacementGroupID: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var scaleDownMode: Output<Either<String, ScaleDownMode>>? = null

    private var scaleSetEvictionPolicy: Output<Either<String, ScaleSetEvictionPolicy>>? = null

    private var scaleSetPriority: Output<Either<String, ScaleSetPriority>>? = null

    private var spotMaxPrice: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<Either<String, AgentPoolType>>? = null

    private var upgradeSettings: Output<AgentPoolUpgradeSettingsArgs>? = null

    private var vmSize: Output<String>? = null

    private var vnetSubnetID: Output<String>? = null

    private var workloadRuntime: Output<Either<String, WorkloadRuntime>>? = null

    /**
     * @param value The name of the agent pool.
     */
    @JvmName("slyiyestojjodxnb")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
     */
    @JvmName("typjfrwucnswqeit")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("bvuvcbgoknydvvai")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
     */
    @JvmName("okclrpbkcucrfoqm")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
     */
    @JvmName("ljdklddbweolsfvx")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
     */
    @JvmName("bwaynfrfaexeatur")
    public suspend fun creationData(`value`: Output<CreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value Whether to enable auto-scaler
     */
    @JvmName("wkalmckvxvlqadmw")
    public suspend fun enableAutoScaling(`value`: Output<Boolean>) {
        this.enableAutoScaling = value
    }

    /**
     * @param value This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
     */
    @JvmName("csbqosxrubfxeskv")
    public suspend fun enableEncryptionAtHost(`value`: Output<Boolean>) {
        this.enableEncryptionAtHost = value
    }

    /**
     * @param value See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
     */
    @JvmName("vswsfyvtolttmslo")
    public suspend fun enableFIPS(`value`: Output<Boolean>) {
        this.enableFIPS = value
    }

    /**
     * @param value Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
     */
    @JvmName("nfcdpymqwkkdpwvn")
    public suspend fun enableNodePublicIP(`value`: Output<Boolean>) {
        this.enableNodePublicIP = value
    }

    /**
     * @param value Whether to enable UltraSSD
     */
    @JvmName("dpvbcivsxxokpgpv")
    public suspend fun enableUltraSSD(`value`: Output<Boolean>) {
        this.enableUltraSSD = value
    }

    /**
     * @param value GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
     */
    @JvmName("olwngphwimnkkvvi")
    public suspend fun gpuInstanceProfile(`value`: Output<Either<String, GPUInstanceProfile>>) {
        this.gpuInstanceProfile = value
    }

    /**
     * @param value This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     */
    @JvmName("hvpveupbasxnrlmi")
    public suspend fun hostGroupID(`value`: Output<String>) {
        this.hostGroupID = value
    }

    /**
     * @param value The Kubelet configuration on the agent pool nodes.
     */
    @JvmName("fhspgqcebqtltllq")
    public suspend fun kubeletConfig(`value`: Output<KubeletConfigArgs>) {
        this.kubeletConfig = value
    }

    /**
     * @param value Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
     */
    @JvmName("expcjeiihalvvppt")
    public suspend fun kubeletDiskType(`value`: Output<Either<String, KubeletDiskType>>) {
        this.kubeletDiskType = value
    }

    /**
     * @param value The OS configuration of Linux agent nodes.
     */
    @JvmName("abrhvbujepcxdisv")
    public suspend fun linuxOSConfig(`value`: Output<LinuxOSConfigArgs>) {
        this.linuxOSConfig = value
    }

    /**
     * @param value The maximum number of nodes for auto-scaling
     */
    @JvmName("noysfjiebomyvabq")
    public suspend fun maxCount(`value`: Output<Int>) {
        this.maxCount = value
    }

    /**
     * @param value The maximum number of pods that can run on a node.
     */
    @JvmName("rnhiyfhojvtkqqdf")
    public suspend fun maxPods(`value`: Output<Int>) {
        this.maxPods = value
    }

    /**
     * @param value The minimum number of nodes for auto-scaling
     */
    @JvmName("apdyajepyjkdghmx")
    public suspend fun minCount(`value`: Output<Int>) {
        this.minCount = value
    }

    /**
     * @param value A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
     */
    @JvmName("linnovhkmobbcgse")
    public suspend fun mode(`value`: Output<Either<String, AgentPoolMode>>) {
        this.mode = value
    }

    /**
     * @param value The node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("jkoovumjflgneasu")
    public suspend fun nodeLabels(`value`: Output<Map<String, String>>) {
        this.nodeLabels = value
    }

    /**
     * @param value This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
     */
    @JvmName("icnvpkcptqomjxbd")
    public suspend fun nodePublicIPPrefixID(`value`: Output<String>) {
        this.nodePublicIPPrefixID = value
    }

    /**
     * @param value The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("qevulmryvylmjtai")
    public suspend fun nodeTaints(`value`: Output<List<String>>) {
        this.nodeTaints = value
    }

    @JvmName("tjngehfskoaojysr")
    public suspend fun nodeTaints(vararg values: Output<String>) {
        this.nodeTaints = Output.all(values.asList())
    }

    /**
     * @param values The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("dtqxhkokyqnbweti")
    public suspend fun nodeTaints(values: List<Output<String>>) {
        this.nodeTaints = Output.all(values)
    }

    /**
     * @param value Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     */
    @JvmName("wigwfnwkvqbbqbfg")
    public suspend fun orchestratorVersion(`value`: Output<String>) {
        this.orchestratorVersion = value
    }

    /**
     * @param value OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     */
    @JvmName("bfoparetpepsruam")
    public suspend fun osDiskSizeGB(`value`: Output<Int>) {
        this.osDiskSizeGB = value
    }

    /**
     * @param value The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     */
    @JvmName("gtcorqvggxaxoowf")
    public suspend fun osDiskType(`value`: Output<Either<String, OSDiskType>>) {
        this.osDiskType = value
    }

    /**
     * @param value Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    @JvmName("pucnbgqupjfhhchy")
    public suspend fun osSKU(`value`: Output<Either<String, OSSKU>>) {
        this.osSKU = value
    }

    /**
     * @param value The operating system type. The default is Linux.
     */
    @JvmName("epnypweruwaeeakd")
    public suspend fun osType(`value`: Output<Either<String, OSType>>) {
        this.osType = value
    }

    /**
     * @param value If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
     */
    @JvmName("qcupdpenvtdpdwav")
    public suspend fun podSubnetID(`value`: Output<String>) {
        this.podSubnetID = value
    }

    /**
     * @param value When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
     */
    @JvmName("xpiwxbpxkpgxagbc")
    public suspend fun powerState(`value`: Output<PowerStateArgs>) {
        this.powerState = value
    }

    /**
     * @param value The ID for Proximity Placement Group.
     */
    @JvmName("xhjsjfvkhqavvrfm")
    public suspend fun proximityPlacementGroupID(`value`: Output<String>) {
        this.proximityPlacementGroupID = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qcwciixsosfxvnsl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("vnotajgwekyssxcc")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
     */
    @JvmName("gdrirldqxqntflyb")
    public suspend fun scaleDownMode(`value`: Output<Either<String, ScaleDownMode>>) {
        this.scaleDownMode = value
    }

    /**
     * @param value This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     */
    @JvmName("wjwmcxetjweuuldk")
    public suspend
    fun scaleSetEvictionPolicy(`value`: Output<Either<String, ScaleSetEvictionPolicy>>) {
        this.scaleSetEvictionPolicy = value
    }

    /**
     * @param value The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
     */
    @JvmName("ngeqbpyskauckkyo")
    public suspend fun scaleSetPriority(`value`: Output<Either<String, ScaleSetPriority>>) {
        this.scaleSetPriority = value
    }

    /**
     * @param value Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
     */
    @JvmName("sdhilrqqieakaytl")
    public suspend fun spotMaxPrice(`value`: Output<Double>) {
        this.spotMaxPrice = value
    }

    /**
     * @param value The tags to be persisted on the agent pool virtual machine scale set.
     */
    @JvmName("jswxjeqhoehesepy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of Agent Pool.
     */
    @JvmName("fhotbvvsilispyjb")
    public suspend fun type(`value`: Output<Either<String, AgentPoolType>>) {
        this.type = value
    }

    /**
     * @param value Settings for upgrading the agentpool
     */
    @JvmName("afewjaujrvdlhiuf")
    public suspend fun upgradeSettings(`value`: Output<AgentPoolUpgradeSettingsArgs>) {
        this.upgradeSettings = value
    }

    /**
     * @param value VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
     */
    @JvmName("itklisxclfsovygk")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
     */
    @JvmName("okyenishiciqbggd")
    public suspend fun vnetSubnetID(`value`: Output<String>) {
        this.vnetSubnetID = value
    }

    /**
     * @param value Determines the type of workload a node can run.
     */
    @JvmName("ytfqmgxuhfbwawcm")
    public suspend fun workloadRuntime(`value`: Output<Either<String, WorkloadRuntime>>) {
        this.workloadRuntime = value
    }

    /**
     * @param value The name of the agent pool.
     */
    @JvmName("nvltexhgxekfkadh")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
     */
    @JvmName("ulqejgbxyxlxbtia")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
     */
    @JvmName("bokomqhtbjruojry")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
     */
    @JvmName("mpeuxydrqbvesroe")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
     */
    @JvmName("vamyreylucbamuul")
    public suspend fun creationData(`value`: CreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
     */
    @JvmName("oqmafbrhhyrxcqyx")
    public suspend fun creationData(argument: suspend CreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = CreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value Whether to enable auto-scaler
     */
    @JvmName("snpjdftmhqwtbwco")
    public suspend fun enableAutoScaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoScaling = mapped
    }

    /**
     * @param value This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
     */
    @JvmName("ewfxsdyshswxhkry")
    public suspend fun enableEncryptionAtHost(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEncryptionAtHost = mapped
    }

    /**
     * @param value See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
     */
    @JvmName("jbxxogspacaamnff")
    public suspend fun enableFIPS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFIPS = mapped
    }

    /**
     * @param value Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
     */
    @JvmName("hdcmifugxicixtkx")
    public suspend fun enableNodePublicIP(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNodePublicIP = mapped
    }

    /**
     * @param value Whether to enable UltraSSD
     */
    @JvmName("trfeflbtvyptgyyh")
    public suspend fun enableUltraSSD(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableUltraSSD = mapped
    }

    /**
     * @param value GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
     */
    @JvmName("koxspwvphmbhguaa")
    public suspend fun gpuInstanceProfile(`value`: Either<String, GPUInstanceProfile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpuInstanceProfile = mapped
    }

    /**
     * @param value GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
     */
    @JvmName("bsinqomturfnhcxl")
    public fun gpuInstanceProfile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GPUInstanceProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gpuInstanceProfile = mapped
    }

    /**
     * @param value GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
     */
    @JvmName("hknnqrrqmqlbqytl")
    public fun gpuInstanceProfile(`value`: GPUInstanceProfile) {
        val toBeMapped = Either.ofRight<String, GPUInstanceProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gpuInstanceProfile = mapped
    }

    /**
     * @param value This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     */
    @JvmName("paoxqvpporxwtggi")
    public suspend fun hostGroupID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroupID = mapped
    }

    /**
     * @param value The Kubelet configuration on the agent pool nodes.
     */
    @JvmName("lnnybrgjowntmqso")
    public suspend fun kubeletConfig(`value`: KubeletConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeletConfig = mapped
    }

    /**
     * @param argument The Kubelet configuration on the agent pool nodes.
     */
    @JvmName("ubpmwtvlqvffvojt")
    public suspend fun kubeletConfig(argument: suspend KubeletConfigArgsBuilder.() -> Unit) {
        val toBeMapped = KubeletConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kubeletConfig = mapped
    }

    /**
     * @param value Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
     */
    @JvmName("qhglwdpielijxbmr")
    public suspend fun kubeletDiskType(`value`: Either<String, KubeletDiskType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeletDiskType = mapped
    }

    /**
     * @param value Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
     */
    @JvmName("jbunyjfajwtsgocy")
    public fun kubeletDiskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KubeletDiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kubeletDiskType = mapped
    }

    /**
     * @param value Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
     */
    @JvmName("eyxwlixpenmldehu")
    public fun kubeletDiskType(`value`: KubeletDiskType) {
        val toBeMapped = Either.ofRight<String, KubeletDiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kubeletDiskType = mapped
    }

    /**
     * @param value The OS configuration of Linux agent nodes.
     */
    @JvmName("rfqplmsqdapweikf")
    public suspend fun linuxOSConfig(`value`: LinuxOSConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxOSConfig = mapped
    }

    /**
     * @param argument The OS configuration of Linux agent nodes.
     */
    @JvmName("owxtrlvmpngshgmr")
    public suspend fun linuxOSConfig(argument: suspend LinuxOSConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxOSConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxOSConfig = mapped
    }

    /**
     * @param value The maximum number of nodes for auto-scaling
     */
    @JvmName("gpgkxctpqrqkkald")
    public suspend fun maxCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCount = mapped
    }

    /**
     * @param value The maximum number of pods that can run on a node.
     */
    @JvmName("jalcmpmmtxbcoakc")
    public suspend fun maxPods(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPods = mapped
    }

    /**
     * @param value The minimum number of nodes for auto-scaling
     */
    @JvmName("kimeatrhjifwaljq")
    public suspend fun minCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCount = mapped
    }

    /**
     * @param value A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
     */
    @JvmName("leeygafwqnwtpwle")
    public suspend fun mode(`value`: Either<String, AgentPoolMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
     */
    @JvmName("flxxgylmrnhiwmuk")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AgentPoolMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
     */
    @JvmName("kvbsygwekuedtyuo")
    public fun mode(`value`: AgentPoolMode) {
        val toBeMapped = Either.ofRight<String, AgentPoolMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("jokyoeboslahdcwk")
    public suspend fun nodeLabels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeLabels = mapped
    }

    /**
     * @param values The node labels to be persisted across all nodes in agent pool.
     */
    @JvmName("fgdstbptpkyltksp")
    public fun nodeLabels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeLabels = mapped
    }

    /**
     * @param value This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
     */
    @JvmName("hvdaakslikkulunb")
    public suspend fun nodePublicIPPrefixID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodePublicIPPrefixID = mapped
    }

    /**
     * @param value The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("dkgxaspufryupxhd")
    public suspend fun nodeTaints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTaints = mapped
    }

    /**
     * @param values The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JvmName("atlaaxvchnoxbjrk")
    public suspend fun nodeTaints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeTaints = mapped
    }

    /**
     * @param value Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     */
    @JvmName("olaudfgfxrfaveii")
    public suspend fun orchestratorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orchestratorVersion = mapped
    }

    /**
     * @param value OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     */
    @JvmName("ytxiavqsbvcptktx")
    public suspend fun osDiskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDiskSizeGB = mapped
    }

    /**
     * @param value The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     */
    @JvmName("qtbqrckmebojstqx")
    public suspend fun osDiskType(`value`: Either<String, OSDiskType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDiskType = mapped
    }

    /**
     * @param value The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     */
    @JvmName("dbsbjghsrxwtdyub")
    public fun osDiskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OSDiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osDiskType = mapped
    }

    /**
     * @param value The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     */
    @JvmName("mofrlcatabxqjsvr")
    public fun osDiskType(`value`: OSDiskType) {
        val toBeMapped = Either.ofRight<String, OSDiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osDiskType = mapped
    }

    /**
     * @param value Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    @JvmName("thwpvbrrdeejyfdx")
    public suspend fun osSKU(`value`: Either<String, OSSKU>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osSKU = mapped
    }

    /**
     * @param value Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    @JvmName("lkngnwklvtsydoxq")
    public fun osSKU(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OSSKU>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osSKU = mapped
    }

    /**
     * @param value Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    @JvmName("agklfqafeiaajfth")
    public fun osSKU(`value`: OSSKU) {
        val toBeMapped = Either.ofRight<String, OSSKU>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osSKU = mapped
    }

    /**
     * @param value The operating system type. The default is Linux.
     */
    @JvmName("hpjtkqjycqlpsrob")
    public suspend fun osType(`value`: Either<String, OSType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operating system type. The default is Linux.
     */
    @JvmName("oylqyrnjapnnrcbe")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operating system type. The default is Linux.
     */
    @JvmName("txfqftevhbketaio")
    public fun osType(`value`: OSType) {
        val toBeMapped = Either.ofRight<String, OSType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
     */
    @JvmName("wnwdfpnkgxckynoi")
    public suspend fun podSubnetID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podSubnetID = mapped
    }

    /**
     * @param value When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
     */
    @JvmName("usjqjjibammiriys")
    public suspend fun powerState(`value`: PowerStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.powerState = mapped
    }

    /**
     * @param argument When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
     */
    @JvmName("jqmhkdenyjtqslig")
    public suspend fun powerState(argument: suspend PowerStateArgsBuilder.() -> Unit) {
        val toBeMapped = PowerStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.powerState = mapped
    }

    /**
     * @param value The ID for Proximity Placement Group.
     */
    @JvmName("aecdxpeolugtqbva")
    public suspend fun proximityPlacementGroupID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroupID = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ibplgwjblnootpfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("whxdwqjjngoqakti")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
     */
    @JvmName("eciisgrcmmmnwhib")
    public suspend fun scaleDownMode(`value`: Either<String, ScaleDownMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownMode = mapped
    }

    /**
     * @param value This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
     */
    @JvmName("ipyyrtpwlojfvyei")
    public fun scaleDownMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScaleDownMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleDownMode = mapped
    }

    /**
     * @param value This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
     */
    @JvmName("wejpesmrgqnketsw")
    public fun scaleDownMode(`value`: ScaleDownMode) {
        val toBeMapped = Either.ofRight<String, ScaleDownMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleDownMode = mapped
    }

    /**
     * @param value This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     */
    @JvmName("tfptofvdjlyugheg")
    public suspend fun scaleSetEvictionPolicy(`value`: Either<String, ScaleSetEvictionPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleSetEvictionPolicy = mapped
    }

    /**
     * @param value This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     */
    @JvmName("dqpwjygqhtmuopoy")
    public fun scaleSetEvictionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScaleSetEvictionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleSetEvictionPolicy = mapped
    }

    /**
     * @param value This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     */
    @JvmName("nimmflxtowkiivwl")
    public fun scaleSetEvictionPolicy(`value`: ScaleSetEvictionPolicy) {
        val toBeMapped = Either.ofRight<String, ScaleSetEvictionPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleSetEvictionPolicy = mapped
    }

    /**
     * @param value The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
     */
    @JvmName("vqtinyjfuvkbkmuw")
    public suspend fun scaleSetPriority(`value`: Either<String, ScaleSetPriority>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleSetPriority = mapped
    }

    /**
     * @param value The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
     */
    @JvmName("hlcybpvhmbysfwwo")
    public fun scaleSetPriority(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScaleSetPriority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleSetPriority = mapped
    }

    /**
     * @param value The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
     */
    @JvmName("lvitlecklddtqfuq")
    public fun scaleSetPriority(`value`: ScaleSetPriority) {
        val toBeMapped = Either.ofRight<String, ScaleSetPriority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleSetPriority = mapped
    }

    /**
     * @param value Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
     */
    @JvmName("auvjaojmlacellcc")
    public suspend fun spotMaxPrice(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotMaxPrice = mapped
    }

    /**
     * @param value The tags to be persisted on the agent pool virtual machine scale set.
     */
    @JvmName("gakftowdmssmgche")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags to be persisted on the agent pool virtual machine scale set.
     */
    @JvmName("cbbgrkkkdgkexxio")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of Agent Pool.
     */
    @JvmName("odaboubmtyytfjmh")
    public suspend fun type(`value`: Either<String, AgentPoolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of Agent Pool.
     */
    @JvmName("egfooghhwdpocplo")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AgentPoolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of Agent Pool.
     */
    @JvmName("tlxyjatedwdscoei")
    public fun type(`value`: AgentPoolType) {
        val toBeMapped = Either.ofRight<String, AgentPoolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Settings for upgrading the agentpool
     */
    @JvmName("kvwbxalgwybnybsx")
    public suspend fun upgradeSettings(`value`: AgentPoolUpgradeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeSettings = mapped
    }

    /**
     * @param argument Settings for upgrading the agentpool
     */
    @JvmName("yoskoofilxmrayvi")
    public suspend
    fun upgradeSettings(argument: suspend AgentPoolUpgradeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPoolUpgradeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgradeSettings = mapped
    }

    /**
     * @param value VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
     */
    @JvmName("hubhvmhgfqcvrjsm")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
     */
    @JvmName("qhnusgubgelroyxy")
    public suspend fun vnetSubnetID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetSubnetID = mapped
    }

    /**
     * @param value Determines the type of workload a node can run.
     */
    @JvmName("juomgexuxwqmflbl")
    public suspend fun workloadRuntime(`value`: Either<String, WorkloadRuntime>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadRuntime = mapped
    }

    /**
     * @param value Determines the type of workload a node can run.
     */
    @JvmName("jgvwlxciejcykokd")
    public fun workloadRuntime(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkloadRuntime>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadRuntime = mapped
    }

    /**
     * @param value Determines the type of workload a node can run.
     */
    @JvmName("cgfdcmlkpkevrvre")
    public fun workloadRuntime(`value`: WorkloadRuntime) {
        val toBeMapped = Either.ofRight<String, WorkloadRuntime>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadRuntime = mapped
    }

    internal fun build(): AgentPoolArgs = AgentPoolArgs(
        agentPoolName = agentPoolName,
        availabilityZones = availabilityZones,
        count = count,
        creationData = creationData,
        enableAutoScaling = enableAutoScaling,
        enableEncryptionAtHost = enableEncryptionAtHost,
        enableFIPS = enableFIPS,
        enableNodePublicIP = enableNodePublicIP,
        enableUltraSSD = enableUltraSSD,
        gpuInstanceProfile = gpuInstanceProfile,
        hostGroupID = hostGroupID,
        kubeletConfig = kubeletConfig,
        kubeletDiskType = kubeletDiskType,
        linuxOSConfig = linuxOSConfig,
        maxCount = maxCount,
        maxPods = maxPods,
        minCount = minCount,
        mode = mode,
        nodeLabels = nodeLabels,
        nodePublicIPPrefixID = nodePublicIPPrefixID,
        nodeTaints = nodeTaints,
        orchestratorVersion = orchestratorVersion,
        osDiskSizeGB = osDiskSizeGB,
        osDiskType = osDiskType,
        osSKU = osSKU,
        osType = osType,
        podSubnetID = podSubnetID,
        powerState = powerState,
        proximityPlacementGroupID = proximityPlacementGroupID,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        scaleDownMode = scaleDownMode,
        scaleSetEvictionPolicy = scaleSetEvictionPolicy,
        scaleSetPriority = scaleSetPriority,
        spotMaxPrice = spotMaxPrice,
        tags = tags,
        type = type,
        upgradeSettings = upgradeSettings,
        vmSize = vmSize,
        vnetSubnetID = vnetSubnetID,
        workloadRuntime = workloadRuntime,
    )
}
