@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.FleetMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.
 * Azure REST API version: 2023-03-15-preview.
 * Other available API versions: 2022-07-02-preview, 2023-06-15-preview, 2023-08-15-preview, 2023-10-15.
 * ## Example Usage
 * ### Creates a FleetMember resource with a long running operation.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fleetMember = new AzureNative.ContainerService.FleetMember("fleetMember", new()
 *     {
 *         ClusterResourceId = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster-1",
 *         FleetMemberName = "member-1",
 *         FleetName = "fleet1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewFleetMember(ctx, "fleetMember", &containerservice.FleetMemberArgs{
 * 			ClusterResourceId: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster-1"),
 * 			FleetMemberName:   pulumi.String("member-1"),
 * 			FleetName:         pulumi.String("fleet1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.FleetMember;
 * import com.pulumi.azurenative.containerservice.FleetMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fleetMember = new FleetMember("fleetMember", FleetMemberArgs.builder()
 *             .clusterResourceId("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster-1")
 *             .fleetMemberName("member-1")
 *             .fleetName("fleet1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:FleetMember member-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/members/{fleetMemberName}
 * ```
 * @property clusterResourceId The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
 * @property fleetMemberName The name of the Fleet member resource.
 * @property fleetName The name of the Fleet resource.
 * @property group The group this member belongs to for multi-cluster update management.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class FleetMemberArgs(
    public val clusterResourceId: Output<String>? = null,
    public val fleetMemberName: Output<String>? = null,
    public val fleetName: Output<String>? = null,
    public val group: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.FleetMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.FleetMemberArgs =
        com.pulumi.azurenative.containerservice.FleetMemberArgs.builder()
            .clusterResourceId(clusterResourceId?.applyValue({ args0 -> args0 }))
            .fleetMemberName(fleetMemberName?.applyValue({ args0 -> args0 }))
            .fleetName(fleetName?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetMemberArgs].
 */
@PulumiTagMarker
public class FleetMemberArgsBuilder internal constructor() {
    private var clusterResourceId: Output<String>? = null

    private var fleetMemberName: Output<String>? = null

    private var fleetName: Output<String>? = null

    private var group: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
     */
    @JvmName("qwcxnenrfunawgvq")
    public suspend fun clusterResourceId(`value`: Output<String>) {
        this.clusterResourceId = value
    }

    /**
     * @param value The name of the Fleet member resource.
     */
    @JvmName("utbvdlggtfysexaa")
    public suspend fun fleetMemberName(`value`: Output<String>) {
        this.fleetMemberName = value
    }

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("ofyeaiighlsuxjvu")
    public suspend fun fleetName(`value`: Output<String>) {
        this.fleetName = value
    }

    /**
     * @param value The group this member belongs to for multi-cluster update management.
     */
    @JvmName("tthrtfxltswlxqeq")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qmvwiycjrdqgnyxk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
     */
    @JvmName("aksskdfiingxstsw")
    public suspend fun clusterResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterResourceId = mapped
    }

    /**
     * @param value The name of the Fleet member resource.
     */
    @JvmName("xpwwxagywbkaxvir")
    public suspend fun fleetMemberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetMemberName = mapped
    }

    /**
     * @param value The name of the Fleet resource.
     */
    @JvmName("qbemjsqnbbfjagit")
    public suspend fun fleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetName = mapped
    }

    /**
     * @param value The group this member belongs to for multi-cluster update management.
     */
    @JvmName("slfalcwvmyfllolg")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vfekqyjvicyoudrm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): FleetMemberArgs = FleetMemberArgs(
        clusterResourceId = clusterResourceId,
        fleetMemberName = fleetMemberName,
        fleetName = fleetName,
        group = group,
        resourceGroupName = resourceGroupName,
    )
}
