@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.MaintenanceConfigurationArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.inputs.TimeInWeekArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.TimeInWeekArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.TimeSpanArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.TimeSpanArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * See [planned maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about planned maintenance.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview.
 * ## Example Usage
 * ### Create/Update Maintenance Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var maintenanceConfiguration = new AzureNative.ContainerService.MaintenanceConfiguration("maintenanceConfiguration", new()
 *     {
 *         ConfigName = "default",
 *         NotAllowedTime = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.TimeSpanArgs
 *             {
 *                 End = "2020-11-30T12:00:00Z",
 *                 Start = "2020-11-26T03:00:00Z",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         TimeInWeek = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.TimeInWeekArgs
 *             {
 *                 Day = "Monday",
 *                 HourSlots = new[]
 *                 {
 *                     1,
 *                     2,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewMaintenanceConfiguration(ctx, "maintenanceConfiguration", &containerservice.MaintenanceConfigurationArgs{
 * 			ConfigName: pulumi.String("default"),
 * 			NotAllowedTime: []containerservice.TimeSpanArgs{
 * 				{
 * 					End:   pulumi.String("2020-11-30T12:00:00Z"),
 * 					Start: pulumi.String("2020-11-26T03:00:00Z"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			TimeInWeek: []containerservice.TimeInWeekArgs{
 * 				{
 * 					Day: pulumi.String("Monday"),
 * 					HourSlots: pulumi.IntArray{
 * 						pulumi.Int(1),
 * 						pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.MaintenanceConfiguration;
 * import com.pulumi.azurenative.containerservice.MaintenanceConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var maintenanceConfiguration = new MaintenanceConfiguration("maintenanceConfiguration", MaintenanceConfigurationArgs.builder()
 *             .configName("default")
 *             .notAllowedTime(Map.ofEntries(
 *                 Map.entry("end", "2020-11-30T12:00:00Z"),
 *                 Map.entry("start", "2020-11-26T03:00:00Z")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .timeInWeek(Map.ofEntries(
 *                 Map.entry("day", "Monday"),
 *                 Map.entry("hourSlots",
 *                     1,
 *                     2)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:MaintenanceConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/maintenanceConfigurations/{configName}
 * ```
 * @property configName The name of the maintenance configuration.
 * @property notAllowedTime Time slots on which upgrade is not allowed.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property timeInWeek If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
 */
public data class MaintenanceConfigurationArgs(
    public val configName: Output<String>? = null,
    public val notAllowedTime: Output<List<TimeSpanArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val timeInWeek: Output<List<TimeInWeekArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.MaintenanceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.MaintenanceConfigurationArgs =
        com.pulumi.azurenative.containerservice.MaintenanceConfigurationArgs.builder()
            .configName(configName?.applyValue({ args0 -> args0 }))
            .notAllowedTime(
                notAllowedTime?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .timeInWeek(
                timeInWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MaintenanceConfigurationArgs].
 */
@PulumiTagMarker
public class MaintenanceConfigurationArgsBuilder internal constructor() {
    private var configName: Output<String>? = null

    private var notAllowedTime: Output<List<TimeSpanArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var timeInWeek: Output<List<TimeInWeekArgs>>? = null

    /**
     * @param value The name of the maintenance configuration.
     */
    @JvmName("yhigtsmqjmuejdsv")
    public suspend fun configName(`value`: Output<String>) {
        this.configName = value
    }

    /**
     * @param value Time slots on which upgrade is not allowed.
     */
    @JvmName("wlwisbfdhpewdmij")
    public suspend fun notAllowedTime(`value`: Output<List<TimeSpanArgs>>) {
        this.notAllowedTime = value
    }

    @JvmName("mwnumfrykkdotqyr")
    public suspend fun notAllowedTime(vararg values: Output<TimeSpanArgs>) {
        this.notAllowedTime = Output.all(values.asList())
    }

    /**
     * @param values Time slots on which upgrade is not allowed.
     */
    @JvmName("xeokfdbglankjenn")
    public suspend fun notAllowedTime(values: List<Output<TimeSpanArgs>>) {
        this.notAllowedTime = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("atiqdoixuigfjwhq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("txkhomqlofqbdyfu")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    @JvmName("utwctbkjdtnretuv")
    public suspend fun timeInWeek(`value`: Output<List<TimeInWeekArgs>>) {
        this.timeInWeek = value
    }

    @JvmName("ukwhqqueerqadure")
    public suspend fun timeInWeek(vararg values: Output<TimeInWeekArgs>) {
        this.timeInWeek = Output.all(values.asList())
    }

    /**
     * @param values If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    @JvmName("vwjmqelwnimcsdmy")
    public suspend fun timeInWeek(values: List<Output<TimeInWeekArgs>>) {
        this.timeInWeek = Output.all(values)
    }

    /**
     * @param value The name of the maintenance configuration.
     */
    @JvmName("intkqihgviqmxirq")
    public suspend fun configName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configName = mapped
    }

    /**
     * @param value Time slots on which upgrade is not allowed.
     */
    @JvmName("kyqwbgksahjpiyqp")
    public suspend fun notAllowedTime(`value`: List<TimeSpanArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notAllowedTime = mapped
    }

    /**
     * @param argument Time slots on which upgrade is not allowed.
     */
    @JvmName("sfmugihimkdnbngw")
    public suspend fun notAllowedTime(argument: List<suspend TimeSpanArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TimeSpanArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.notAllowedTime = mapped
    }

    /**
     * @param argument Time slots on which upgrade is not allowed.
     */
    @JvmName("fiqljymwpbouxrha")
    public suspend fun notAllowedTime(vararg argument: suspend TimeSpanArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TimeSpanArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.notAllowedTime = mapped
    }

    /**
     * @param argument Time slots on which upgrade is not allowed.
     */
    @JvmName("ihvrrebjubpgoqlx")
    public suspend fun notAllowedTime(argument: suspend TimeSpanArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TimeSpanArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notAllowedTime = mapped
    }

    /**
     * @param values Time slots on which upgrade is not allowed.
     */
    @JvmName("rlfhvopstnlckwtm")
    public suspend fun notAllowedTime(vararg values: TimeSpanArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notAllowedTime = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ebvxtkhragbkjijh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("bmbmitmvkpvgfbpt")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    @JvmName("cvhuchxsrsarvylh")
    public suspend fun timeInWeek(`value`: List<TimeInWeekArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeInWeek = mapped
    }

    /**
     * @param argument If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    @JvmName("tcharookfvvctapq")
    public suspend fun timeInWeek(argument: List<suspend TimeInWeekArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TimeInWeekArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.timeInWeek = mapped
    }

    /**
     * @param argument If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    @JvmName("riylckloyjmhnyje")
    public suspend fun timeInWeek(vararg argument: suspend TimeInWeekArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TimeInWeekArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.timeInWeek = mapped
    }

    /**
     * @param argument If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    @JvmName("qwskxnvkunogvvtj")
    public suspend fun timeInWeek(argument: suspend TimeInWeekArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TimeInWeekArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.timeInWeek = mapped
    }

    /**
     * @param values If two array entries specify the same day of the week, the applied configuration is the union of times in both entries.
     */
    @JvmName("amcswlviymcygdor")
    public suspend fun timeInWeek(vararg values: TimeInWeekArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeInWeek = mapped
    }

    internal fun build(): MaintenanceConfigurationArgs = MaintenanceConfigurationArgs(
        configName = configName,
        notAllowedTime = notAllowedTime,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        timeInWeek = timeInWeek,
    )
}
