@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceLinuxProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceNetworkProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAADProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAPIServerAccessProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAddonProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAgentPoolProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAutoUpgradeProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAzureMonitorProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterHTTPProxyConfigResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterIdentityResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterOIDCIssuerProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPodIdentityProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPropertiesResponseAutoScalerProfile
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSKUResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSecurityProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterServicePrincipalProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterStorageProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterWindowsProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterWorkloadAutoScalerProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.PowerStateResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.PrivateLinkResourceResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.UserAssignedIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceLinuxProfileResponse.Companion.toKotlin as containerServiceLinuxProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ContainerServiceNetworkProfileResponse.Companion.toKotlin as containerServiceNetworkProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAADProfileResponse.Companion.toKotlin as managedClusterAADProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAPIServerAccessProfileResponse.Companion.toKotlin as managedClusterAPIServerAccessProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAddonProfileResponse.Companion.toKotlin as managedClusterAddonProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAgentPoolProfileResponse.Companion.toKotlin as managedClusterAgentPoolProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAutoUpgradeProfileResponse.Companion.toKotlin as managedClusterAutoUpgradeProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAzureMonitorProfileResponse.Companion.toKotlin as managedClusterAzureMonitorProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterHTTPProxyConfigResponse.Companion.toKotlin as managedClusterHTTPProxyConfigResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterIdentityResponse.Companion.toKotlin as managedClusterIdentityResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterOIDCIssuerProfileResponse.Companion.toKotlin as managedClusterOIDCIssuerProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPodIdentityProfileResponse.Companion.toKotlin as managedClusterPodIdentityProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPropertiesResponseAutoScalerProfile.Companion.toKotlin as managedClusterPropertiesResponseAutoScalerProfileToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSKUResponse.Companion.toKotlin as managedClusterSKUResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterSecurityProfileResponse.Companion.toKotlin as managedClusterSecurityProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterServicePrincipalProfileResponse.Companion.toKotlin as managedClusterServicePrincipalProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterStorageProfileResponse.Companion.toKotlin as managedClusterStorageProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterWindowsProfileResponse.Companion.toKotlin as managedClusterWindowsProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterWorkloadAutoScalerProfileResponse.Companion.toKotlin as managedClusterWorkloadAutoScalerProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.PowerStateResponse.Companion.toKotlin as powerStateResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.PrivateLinkResourceResponse.Companion.toKotlin as privateLinkResourceResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.UserAssignedIdentityResponse.Companion.toKotlin as userAssignedIdentityResponseToKotlin

/**
 * Builder for [ManagedCluster].
 */
@PulumiTagMarker
public class ManagedClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedClusterArgs = ManagedClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedClusterArgsBuilder.() -> Unit) {
        val builder = ManagedClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedCluster {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.ManagedCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedCluster(builtJavaResource)
    }
}

/**
 * Managed cluster.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2017-08-31, 2019-02-01, 2019-06-01, 2021-05-01, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview.
 * When creating a managed cluster you must define at least one agent pool inline via the `agentPoolProfiles` property. The Azure API does not currently allow this property to be updated directly. Instead, additional agent pools can be defined via the `AgentPool` resource. If needing to change the initial agent pool profile property, you can either trigger the whole cluster to be re-created by using the [replaceOnChanges resource option](https://www.pulumi.com/docs/concepts/options/replaceonchanges/), or make the change directly in Azure then use `pulumi refresh` to update the stack's stack to match.
 * ## Example Usage
 * ### Create Managed Cluster using an agent pool snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *                 {
 *                     SourceResourceId = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1",
 *                 },
 *                 EnableFIPS = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * CreationData: {
 * SourceResourceId: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
 * },
 * EnableFIPS: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(false),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("creationData", Map.of("sourceResourceId", "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1")),
 *                 Map.entry("enableFIPS", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with AKS-managed NAT gateway as outbound type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = false,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerSku = "standard",
 *             NatGatewayProfile = new AzureNative.ContainerService.Inputs.ManagedClusterNATGatewayProfileArgs
 *             {
 *                 ManagedOutboundIPProfile = new AzureNative.ContainerService.Inputs.ManagedClusterManagedOutboundIPProfileArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             OutboundType = "managedNATGateway",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(false),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerSku: pulumi.String("standard"),
 * NatGatewayProfile: interface{}{
 * ManagedOutboundIPProfile: &containerservice.ManagedClusterManagedOutboundIPProfileArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * OutboundType: pulumi.String("managedNATGateway"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", false),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("natGatewayProfile", Map.of("managedOutboundIPProfile", Map.of("count", 2))),
 *                 Map.entry("outboundType", "managedNATGateway")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Azure KeyVault Secrets Provider Addon
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles =
 *         {
 *             { "azureKeyvaultSecretsProvider", new AzureNative.ContainerService.Inputs.ManagedClusterAddonProfileArgs
 *             {
 *                 Config =
 *                 {
 *                     { "enableSecretRotation", "true" },
 *                     { "rotationPollInterval", "2m" },
 *                 },
 *                 Enabled = true,
 *             } },
 *         },
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: containerservice.ManagedClusterAddonProfileMap{
 * "azureKeyvaultSecretsProvider": &containerservice.ManagedClusterAddonProfileArgs{
 * Config: pulumi.StringMap{
 * "enableSecretRotation": pulumi.String("true"),
 * "rotationPollInterval": pulumi.String("2m"),
 * },
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles(Map.of("azureKeyvaultSecretsProvider", Map.ofEntries(
 *                 Map.entry("config", Map.ofEntries(
 *                     Map.entry("enableSecretRotation", "true"),
 *                     Map.entry("rotationPollInterval", "2m")
 *                 )),
 *                 Map.entry("enabled", true)
 *             )))
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Dedicated Host Group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 HostGroupID = "/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * HostGroupID: pulumi.String("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(false),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("hostGroupID", "/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with EncryptionAtHost enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with FIPS enabled OS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableFIPS = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableFIPS: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(false),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableFIPS", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with GPUMIG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 GpuInstanceProfile = "MIG3g",
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_ND96asr_v4",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * GpuInstanceProfile: pulumi.String("MIG3g"),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_ND96asr_v4"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * HttpProxy: pulumi.String("http://myproxy.server.com:8080"),
 * HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * NoProxy: pulumi.StringArray{
 * pulumi.String("localhost"),
 * pulumi.String("127.0.0.1"),
 * },
 * TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * },
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("gpuInstanceProfile", "MIG3g"),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_ND96asr_v4")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(Map.ofEntries(
 *                 Map.entry("httpProxy", "http://myproxy.server.com:8080"),
 *                 Map.entry("httpsProxy", "https://myproxy.server.com:8080"),
 *                 Map.entry("noProxy",
 *                     "localhost",
 *                     "127.0.0.1"),
 *                 Map.entry("trustedCa", "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *             ))
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with HTTP proxy configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * HttpProxy: pulumi.String("http://myproxy.server.com:8080"),
 * HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * NoProxy: pulumi.StringArray{
 * pulumi.String("localhost"),
 * pulumi.String("127.0.0.1"),
 * },
 * TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * },
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(Map.ofEntries(
 *                 Map.entry("httpProxy", "http://myproxy.server.com:8080"),
 *                 Map.entry("httpsProxy", "https://myproxy.server.com:8080"),
 *                 Map.entry("noProxy",
 *                     "localhost",
 *                     "127.0.0.1"),
 *                 Map.entry("trustedCa", "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *             ))
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with LongTermSupport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             DisableRunCommand = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Base",
 *             Tier = "Premium",
 *         },
 *         SupportPlan = "AKSLongTermSupport",
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * DisableRunCommand: pulumi.Bool(true),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Base"),
 * Tier: pulumi.String("Premium"),
 * },
 * SupportPlan: pulumi.String("AKSLongTermSupport"),
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.of("disableRunCommand", true))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Base"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .supportPlan("AKSLongTermSupport")
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Node Public IP Prefix
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 NodePublicIPPrefixID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * NodePublicIPPrefixID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("nodePublicIPPrefixID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with OSSKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsSKU = "AzureLinux",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsSKU: pulumi.String("AzureLinux"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * HttpProxy: pulumi.String("http://myproxy.server.com:8080"),
 * HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * NoProxy: pulumi.StringArray{
 * pulumi.String("localhost"),
 * pulumi.String("127.0.0.1"),
 * },
 * TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * },
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osSKU", "AzureLinux"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(Map.ofEntries(
 *                 Map.entry("httpProxy", "http://myproxy.server.com:8080"),
 *                 Map.entry("httpsProxy", "https://myproxy.server.com:8080"),
 *                 Map.entry("noProxy",
 *                     "localhost",
 *                     "127.0.0.1"),
 *                 Map.entry("trustedCa", "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *             ))
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with PPG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 ProximityPlacementGroupID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * ProximityPlacementGroupID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("proximityPlacementGroupID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with PodIdentity enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         PodIdentityProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPodIdentityProfileArgs
 *         {
 *             AllowNetworkPluginKubenet = true,
 *             Enabled = true,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * PodIdentityProfile: &containerservice.ManagedClusterPodIdentityProfileArgs{
 * AllowNetworkPluginKubenet: pulumi.Bool(true),
 * Enabled: pulumi.Bool(true),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .podIdentityProfile(Map.ofEntries(
 *                 Map.entry("allowNetworkPluginKubenet", true),
 *                 Map.entry("enabled", true)
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with RunCommand disabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             DisableRunCommand = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * DisableRunCommand: pulumi.Bool(true),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.of("disableRunCommand", true))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Security Profile configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         SecurityProfile = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileArgs
 *         {
 *             Defender = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileDefenderArgs
 *             {
 *                 LogAnalyticsWorkspaceResourceId = "/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME",
 *                 SecurityMonitoring = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *             WorkloadIdentity = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs
 *             {
 *                 Enabled = true,
 *             },
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * SecurityProfile: containerservice.ManagedClusterSecurityProfileResponse{
 * Defender: interface{}{
 * LogAnalyticsWorkspaceResourceId: pulumi.String("/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
 * SecurityMonitoring: &containerservice.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * WorkloadIdentity: &containerservice.ManagedClusterSecurityProfileWorkloadIdentityArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("defender", Map.ofEntries(
 *                     Map.entry("logAnalyticsWorkspaceResourceId", "/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
 *                     Map.entry("securityMonitoring", Map.of("enabled", true))
 *                 )),
 *                 Map.entry("workloadIdentity", Map.of("enabled", true))
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with UltraSSD enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 EnableUltraSSD = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * EnableUltraSSD: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("enableUltraSSD", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with user-assigned NAT gateway as outbound type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = false,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerSku = "standard",
 *             OutboundType = "userAssignedNATGateway",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(false),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("userAssignedNATGateway"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", false),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "userAssignedNATGateway")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Private Cluster with Public FQDN specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             EnablePrivateCluster = true,
 *             EnablePrivateClusterPublicFQDN = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * EnablePrivateCluster: pulumi.Bool(true),
 * EnablePrivateClusterPublicFQDN: pulumi.Bool(true),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.ofEntries(
 *                 Map.entry("enablePrivateCluster", true),
 *                 Map.entry("enablePrivateClusterPublicFQDN", true)
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Private Cluster with fqdn subdomain specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             EnablePrivateCluster = true,
 *             PrivateDNSZone = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io",
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         FqdnSubdomain = "domain1",
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * EnablePrivateCluster: pulumi.Bool(true),
 * PrivateDNSZone: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io"),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * FqdnSubdomain: pulumi.String("domain1"),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.ofEntries(
 *                 Map.entry("enablePrivateCluster", true),
 *                 Map.entry("privateDNSZone", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .fqdnSubdomain("domain1")
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create/Update AAD Managed Cluster with EnableAzureRBAC
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AadProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAADProfileArgs
 *         {
 *             EnableAzureRBAC = true,
 *             Managed = true,
 *         },
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 AvailabilityZones = new[]
 *                 {
 *                     "1",
 *                     "2",
 *                     "3",
 *                 },
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS1_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AadProfile: &containerservice.ManagedClusterAADProfileArgs{
 * EnableAzureRBAC: pulumi.Bool(true),
 * Managed: pulumi.Bool(true),
 * },
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * AvailabilityZones: pulumi.StringArray{
 * pulumi.String("1"),
 * pulumi.String("2"),
 * pulumi.String("3"),
 * },
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS1_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .aadProfile(Map.ofEntries(
 *                 Map.entry("enableAzureRBAC", true),
 *                 Map.entry("managed", true)
 *             ))
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("availabilityZones",
 *                     "1",
 *                     "2",
 *                     "3"),
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS1_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:ManagedCluster clustername1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}
 * ```
 */
public class ManagedCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.ManagedCluster,
) : KotlinCustomResource(javaResource, ManagedClusterMapper) {
    /**
     * The Azure Active Directory configuration.
     */
    public val aadProfile: Output<ManagedClusterAADProfileResponse>?
        get() = javaResource.aadProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterAADProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The profile of managed cluster add-on.
     */
    public val addonProfiles: Output<Map<String, ManagedClusterAddonProfileResponse>>?
        get() = javaResource.addonProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            managedClusterAddonProfileResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The agent pool properties.
     */
    public val agentPoolProfiles: Output<List<ManagedClusterAgentPoolProfileResponse>>?
        get() = javaResource.agentPoolProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        managedClusterAgentPoolProfileResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The access profile for managed cluster API server.
     */
    public val apiServerAccessProfile: Output<ManagedClusterAPIServerAccessProfileResponse>?
        get() = javaResource.apiServerAccessProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterAPIServerAccessProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Parameters to be applied to the cluster-autoscaler when enabled
     */
    public val autoScalerProfile: Output<ManagedClusterPropertiesResponseAutoScalerProfile>?
        get() = javaResource.autoScalerProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterPropertiesResponseAutoScalerProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The auto upgrade configuration.
     */
    public val autoUpgradeProfile: Output<ManagedClusterAutoUpgradeProfileResponse>?
        get() = javaResource.autoUpgradeProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterAutoUpgradeProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Monitor addon profiles for monitoring the managed cluster.
     */
    public val azureMonitorProfile: Output<ManagedClusterAzureMonitorProfileResponse>?
        get() = javaResource.azureMonitorProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterAzureMonitorProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses, which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS, allowing the Azure Portal to function properly.
     */
    public val azurePortalFQDN: Output<String>
        get() = javaResource.azurePortalFQDN().applyValue({ args0 -> args0 })

    /**
     * If kubernetesVersion was a fully specified version <major.minor.patch>, this field will be exactly equal to it. If kubernetesVersion was <major.minor>, this field will contain the full <major.minor.patch> version being used.
     */
    public val currentKubernetesVersion: Output<String>
        get() = javaResource.currentKubernetesVersion().applyValue({ args0 -> args0 })

    /**
     * If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     */
    public val disableLocalAccounts: Output<Boolean>?
        get() = javaResource.disableLocalAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
     */
    public val diskEncryptionSetID: Output<String>?
        get() = javaResource.diskEncryptionSetID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This cannot be updated once the Managed Cluster has been created.
     */
    public val dnsPrefix: Output<String>?
        get() = javaResource.dnsPrefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
     */
    public val enablePodSecurityPolicy: Output<Boolean>?
        get() = javaResource.enablePodSecurityPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable Kubernetes Role-Based Access Control.
     */
    public val enableRBAC: Output<Boolean>?
        get() = javaResource.enableRBAC().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extended location of the Virtual Machine.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The FQDN of the master pool.
     */
    public val fqdn: Output<String>
        get() = javaResource.fqdn().applyValue({ args0 -> args0 })

    /**
     * This cannot be updated once the Managed Cluster has been created.
     */
    public val fqdnSubdomain: Output<String>?
        get() = javaResource.fqdnSubdomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configurations for provisioning the cluster with HTTP proxy servers.
     */
    public val httpProxyConfig: Output<ManagedClusterHTTPProxyConfigResponse>?
        get() = javaResource.httpProxyConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedClusterHTTPProxyConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identity of the managed cluster, if configured.
     */
    public val identity: Output<ManagedClusterIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Identities associated with the cluster.
     */
    public val identityProfile: Output<Map<String, UserAssignedIdentityResponse>>?
        get() = javaResource.identityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            userAssignedIdentityResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     */
    public val kubernetesVersion: Output<String>?
        get() = javaResource.kubernetesVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The profile for Linux VMs in the Managed Cluster.
     */
    public val linuxProfile: Output<ContainerServiceLinuxProfileResponse>?
        get() = javaResource.linuxProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerServiceLinuxProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The max number of agent pools for the managed cluster.
     */
    public val maxAgentPools: Output<Int>
        get() = javaResource.maxAgentPools().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network configuration profile.
     */
    public val networkProfile: Output<ContainerServiceNetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> containerServiceNetworkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource group containing agent pool nodes.
     */
    public val nodeResourceGroup: Output<String>?
        get() = javaResource.nodeResourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OIDC issuer profile of the Managed Cluster.
     */
    public val oidcIssuerProfile: Output<ManagedClusterOIDCIssuerProfileResponse>?
        get() = javaResource.oidcIssuerProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterOIDCIssuerProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
     */
    public val podIdentityProfile: Output<ManagedClusterPodIdentityProfileResponse>?
        get() = javaResource.podIdentityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterPodIdentityProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Power State of the cluster.
     */
    public val powerState: Output<PowerStateResponse>
        get() = javaResource.powerState().applyValue({ args0 ->
            args0.let({ args0 ->
                powerStateResponseToKotlin(args0)
            })
        })

    /**
     * The FQDN of private cluster.
     */
    public val privateFQDN: Output<String>
        get() = javaResource.privateFQDN().applyValue({ args0 -> args0 })

    /**
     * Private link resources associated with the cluster.
     */
    public val privateLinkResources: Output<List<PrivateLinkResourceResponse>>?
        get() = javaResource.privateLinkResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateLinkResourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The current provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Allow or deny public network access for AKS
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Security profile for the managed cluster.
     */
    public val securityProfile: Output<ManagedClusterSecurityProfileResponse>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedClusterSecurityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    public val servicePrincipalProfile: Output<ManagedClusterServicePrincipalProfileResponse>?
        get() = javaResource.servicePrincipalProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterServicePrincipalProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The managed cluster SKU.
     */
    public val sku: Output<ManagedClusterSKUResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterSKUResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Storage profile for the managed cluster.
     */
    public val storageProfile: Output<ManagedClusterStorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedClusterStorageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    public val supportPlan: Output<String>?
        get() = javaResource.supportPlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The profile for Windows VMs in the Managed Cluster.
     */
    public val windowsProfile: Output<ManagedClusterWindowsProfileResponse>?
        get() = javaResource.windowsProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedClusterWindowsProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Workload Auto-scaler profile for the managed cluster.
     */
    public val workloadAutoScalerProfile: Output<ManagedClusterWorkloadAutoScalerProfileResponse>?
        get() = javaResource.workloadAutoScalerProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedClusterWorkloadAutoScalerProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ManagedClusterMapper : ResourceMapper<ManagedCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.ManagedCluster::class == javaResource::class

    override fun map(javaResource: Resource): ManagedCluster = ManagedCluster(
        javaResource as
            com.pulumi.azurenative.containerservice.ManagedCluster,
    )
}

/**
 * @see [ManagedCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedCluster].
 */
public suspend fun managedCluster(
    name: String,
    block: suspend ManagedClusterResourceBuilder.() -> Unit,
): ManagedCluster {
    val builder = ManagedClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedCluster(name: String): ManagedCluster {
    val builder = ManagedClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
