@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.SnapshotArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.SnapshotType
import com.pulumi.azurenative.containerservice.kotlin.inputs.CreationDataArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.CreationDataArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A node pool snapshot resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-08-01.
 * Other available API versions: 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview.
 * ## Example Usage
 * ### Create/Update Snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.ContainerService.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *         {
 *             SourceResourceId = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool0",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "snapshot1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *             { "key2", "val2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewSnapshot(ctx, "snapshot", &containerservice.SnapshotArgs{
 * 			CreationData: &containerservice.CreationDataArgs{
 * 				SourceResourceId: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool0"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("snapshot1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 				"key2": pulumi.String("val2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.Snapshot;
 * import com.pulumi.azurenative.containerservice.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.of("sourceResourceId", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool0"))
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .resourceName("snapshot1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "val1"),
 *                 Map.entry("key2", "val2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:Snapshot snapshot1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/snapshots/{resourceName}
 * ```
 * @property creationData CreationData to be used to specify the source agent pool resource ID to create this snapshot.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property snapshotType The type of a snapshot. The default is NodePool.
 * @property tags Resource tags.
 */
public data class SnapshotArgs(
    public val creationData: Output<CreationDataArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val snapshotType: Output<Either<String, SnapshotType>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.SnapshotArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.SnapshotArgs =
        com.pulumi.azurenative.containerservice.SnapshotArgs.builder()
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .snapshotType(
                snapshotType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var creationData: Output<CreationDataArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var snapshotType: Output<Either<String, SnapshotType>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value CreationData to be used to specify the source agent pool resource ID to create this snapshot.
     */
    @JvmName("otcpcndwulfsdkve")
    public suspend fun creationData(`value`: Output<CreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("plnrnvkalyvhaspv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("emaqdmhlisaxwsyv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("vtcpsrqduwlwplow")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("abclxmowtsvsifnd")
    public suspend fun snapshotType(`value`: Output<Either<String, SnapshotType>>) {
        this.snapshotType = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ihyipervamjixuib")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value CreationData to be used to specify the source agent pool resource ID to create this snapshot.
     */
    @JvmName("wnyymyhdwrbhtatm")
    public suspend fun creationData(`value`: CreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument CreationData to be used to specify the source agent pool resource ID to create this snapshot.
     */
    @JvmName("idmymjdixwyflpqk")
    public suspend fun creationData(argument: suspend CreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = CreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qickjnytqxwitqnl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sivfhftqcujrfyvr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("xalmbdweqttikwbg")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("kfmjcmsfiormghww")
    public suspend fun snapshotType(`value`: Either<String, SnapshotType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotType = mapped
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("ggnkoccbtathlfee")
    public fun snapshotType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SnapshotType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotType = mapped
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("kwjcgqmiahuiaggq")
    public fun snapshotType(`value`: SnapshotType) {
        val toBeMapped = Either.ofRight<String, SnapshotType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotType = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("utrqfyutwvmxhhhk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("igtxsncfqfvvvitd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        creationData = creationData,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        snapshotType = snapshotType,
        tags = tags,
    )
}
