@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.TrustedAccessRoleBindingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines binding between a resource and role
 * Azure REST API version: 2023-05-02-preview. Prior API version in Azure Native 1.x: 2022-04-02-preview.
 * Other available API versions: 2023-06-02-preview, 2023-07-02-preview, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview.
 * ## Example Usage
 * ### Create or update a trusted access role binding
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trustedAccessRoleBinding = new AzureNative.ContainerService.TrustedAccessRoleBinding("trustedAccessRoleBinding", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         Roles = new[]
 *         {
 *             "Microsoft.MachineLearningServices/workspaces/reader",
 *             "Microsoft.MachineLearningServices/workspaces/writer",
 *         },
 *         SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/b/providers/Microsoft.MachineLearningServices/workspaces/c",
 *         TrustedAccessRoleBindingName = "binding1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewTrustedAccessRoleBinding(ctx, "trustedAccessRoleBinding", &containerservice.TrustedAccessRoleBindingArgs{
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			Roles: pulumi.StringArray{
 * 				pulumi.String("Microsoft.MachineLearningServices/workspaces/reader"),
 * 				pulumi.String("Microsoft.MachineLearningServices/workspaces/writer"),
 * 			},
 * 			SourceResourceId:             pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/b/providers/Microsoft.MachineLearningServices/workspaces/c"),
 * 			TrustedAccessRoleBindingName: pulumi.String("binding1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.TrustedAccessRoleBinding;
 * import com.pulumi.azurenative.containerservice.TrustedAccessRoleBindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trustedAccessRoleBinding = new TrustedAccessRoleBinding("trustedAccessRoleBinding", TrustedAccessRoleBindingArgs.builder()
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .roles(
 *                 "Microsoft.MachineLearningServices/workspaces/reader",
 *                 "Microsoft.MachineLearningServices/workspaces/writer")
 *             .sourceResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/b/providers/Microsoft.MachineLearningServices/workspaces/c")
 *             .trustedAccessRoleBindingName("binding1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:TrustedAccessRoleBinding binding1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/trustedAccessRoleBindings/{trustedAccessRoleBindingName}
 * ```
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property roles A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
 * @property sourceResourceId The ARM resource ID of source resource that trusted access is configured for.
 * @property trustedAccessRoleBindingName The name of trusted access role binding.
 */
public data class TrustedAccessRoleBindingArgs(
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val roles: Output<List<String>>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val trustedAccessRoleBindingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.TrustedAccessRoleBindingArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.TrustedAccessRoleBindingArgs =
        com.pulumi.azurenative.containerservice.TrustedAccessRoleBindingArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .trustedAccessRoleBindingName(trustedAccessRoleBindingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustedAccessRoleBindingArgs].
 */
@PulumiTagMarker
public class TrustedAccessRoleBindingArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var roles: Output<List<String>>? = null

    private var sourceResourceId: Output<String>? = null

    private var trustedAccessRoleBindingName: Output<String>? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cakxddveslgaismi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("mgrktafhdpywdixj")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
     */
    @JvmName("ibpacrqkmpuvggii")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("ohumvernrdiujuju")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
     */
    @JvmName("ncluojlduyvadcos")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value The ARM resource ID of source resource that trusted access is configured for.
     */
    @JvmName("yjctxnjurdkmhvoj")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value The name of trusted access role binding.
     */
    @JvmName("wupjuplupenlxwlg")
    public suspend fun trustedAccessRoleBindingName(`value`: Output<String>) {
        this.trustedAccessRoleBindingName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dwerwrpxkecimssp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("gogahxmeiokjlgoj")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
     */
    @JvmName("ipingqcvwltwtybq")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values A list of roles to bind, each item is a resource type qualified role name. For example: 'Microsoft.MachineLearningServices/workspaces/reader'.
     */
    @JvmName("phgpataqvoigwyvw")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value The ARM resource ID of source resource that trusted access is configured for.
     */
    @JvmName("nurdwqxxgeymybfj")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value The name of trusted access role binding.
     */
    @JvmName("ihvpvfoyxxudvtdn")
    public suspend fun trustedAccessRoleBindingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedAccessRoleBindingName = mapped
    }

    internal fun build(): TrustedAccessRoleBindingArgs = TrustedAccessRoleBindingArgs(
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        roles = roles,
        sourceResourceId = sourceResourceId,
        trustedAccessRoleBindingName = trustedAccessRoleBindingName,
    )
}
