@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterUpdateResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStatusResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStrategyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterUpdateResponse.Companion.toKotlin as managedClusterUpdateResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStatusResponse.Companion.toKotlin as updateRunStatusResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStrategyResponse.Companion.toKotlin as updateRunStrategyResponseToKotlin

/**
 * Builder for [UpdateRun].
 */
@PulumiTagMarker
public class UpdateRunResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UpdateRunArgs = UpdateRunArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UpdateRunArgsBuilder.() -> Unit) {
        val builder = UpdateRunArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UpdateRun {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.UpdateRun(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return UpdateRun(builtJavaResource)
    }
}

/**
 * A multi-stage process to perform update operations across members of a Fleet.
 * Azure REST API version: 2023-03-15-preview.
 * Other available API versions: 2023-06-15-preview, 2023-08-15-preview, 2023-10-15.
 * ## Example Usage
 * ### Create an UpdateRun.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var updateRun = new AzureNative.ContainerService.UpdateRun("updateRun", new()
 *     {
 *         FleetName = "fleet1",
 *         ManagedClusterUpdate = new AzureNative.ContainerService.Inputs.ManagedClusterUpdateArgs
 *         {
 *             Upgrade = new AzureNative.ContainerService.Inputs.ManagedClusterUpgradeSpecArgs
 *             {
 *                 KubernetesVersion = "1.26.1",
 *                 Type = "Full",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Strategy = new AzureNative.ContainerService.Inputs.UpdateRunStrategyArgs
 *         {
 *             Stages = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.UpdateStageArgs
 *                 {
 *                     AfterStageWaitInSeconds = 3600,
 *                     Groups = new[]
 *                     {
 *                         new AzureNative.ContainerService.Inputs.UpdateGroupArgs
 *                         {
 *                             Name = "group-a",
 *                         },
 *                     },
 *                     Name = "stage1",
 *                 },
 *             },
 *         },
 *         UpdateRunName = "run1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewUpdateRun(ctx, "updateRun", &containerservice.UpdateRunArgs{
 * FleetName: pulumi.String("fleet1"),
 * ManagedClusterUpdate: containerservice.ManagedClusterUpdateResponse{
 * Upgrade: &containerservice.ManagedClusterUpgradeSpecArgs{
 * KubernetesVersion: pulumi.String("1.26.1"),
 * Type: pulumi.String("Full"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Strategy: containerservice.UpdateRunStrategyResponse{
 * Stages: containerservice.UpdateStageArray{
 * interface{}{
 * AfterStageWaitInSeconds: pulumi.Int(3600),
 * Groups: containerservice.UpdateGroupArray{
 * &containerservice.UpdateGroupArgs{
 * Name: pulumi.String("group-a"),
 * },
 * },
 * Name: pulumi.String("stage1"),
 * },
 * },
 * },
 * UpdateRunName: pulumi.String("run1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.UpdateRun;
 * import com.pulumi.azurenative.containerservice.UpdateRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateRun = new UpdateRun("updateRun", UpdateRunArgs.builder()
 *             .fleetName("fleet1")
 *             .managedClusterUpdate(Map.of("upgrade", Map.ofEntries(
 *                 Map.entry("kubernetesVersion", "1.26.1"),
 *                 Map.entry("type", "Full")
 *             )))
 *             .resourceGroupName("rg1")
 *             .strategy(Map.of("stages", Map.ofEntries(
 *                 Map.entry("afterStageWaitInSeconds", 3600),
 *                 Map.entry("groups", Map.of("name", "group-a")),
 *                 Map.entry("name", "stage1")
 *             )))
 *             .updateRunName("run1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:UpdateRun run1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/updateRuns/{updateRunName}
 * ```
 */
public class UpdateRun internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.UpdateRun,
) : KotlinCustomResource(javaResource, UpdateRunMapper) {
    /**
     * If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started.
     */
    public val managedClusterUpdate: Output<ManagedClusterUpdateResponse>
        get() = javaResource.managedClusterUpdate().applyValue({ args0 ->
            args0.let({ args0 ->
                managedClusterUpdateResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the UpdateRun resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The status of the UpdateRun.
     */
    public val status: Output<UpdateRunStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                updateRunStatusResponseToKotlin(args0)
            })
        })

    /**
     * The strategy defines the order in which the clusters will be updated.
     * If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
     * The strategy of the UpdateRun can be modified until the run is started.
     */
    public val strategy: Output<UpdateRunStrategyResponse>?
        get() = javaResource.strategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    updateRunStrategyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UpdateRunMapper : ResourceMapper<UpdateRun> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.UpdateRun::class == javaResource::class

    override fun map(javaResource: Resource): UpdateRun = UpdateRun(
        javaResource as
            com.pulumi.azurenative.containerservice.UpdateRun,
    )
}

/**
 * @see [UpdateRun].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UpdateRun].
 */
public suspend fun updateRun(name: String, block: suspend UpdateRunResourceBuilder.() -> Unit):
    UpdateRun {
    val builder = UpdateRunResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UpdateRun].
 * @param name The _unique_ name of the resulting resource.
 */
public fun updateRun(name: String): UpdateRun {
    val builder = UpdateRunResourceBuilder()
    builder.name(name)
    return builder.build()
}
