@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If not specified, the default is 'Free'. See [AKS Pricing Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
 */
public enum class ManagedClusterSKUTier(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.ManagedClusterSKUTier,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.ManagedClusterSKUTier> {
    /**
     * Cluster has premium capabilities in addition to all of the capabilities included in 'Standard'. Premium enables selection of LongTermSupport (aka.ms/aks/lts) for certain Kubernetes versions.
     */
    Premium(com.pulumi.azurenative.containerservice.enums.ManagedClusterSKUTier.Premium),

    /**
     * Recommended for mission-critical and production workloads. Includes Kubernetes control plane autoscaling, workload-intensive testing, and up to 5,000 nodes per cluster. Guarantees 99.95% availability of the Kubernetes API server endpoint for clusters that use Availability Zones and 99.9% of availability for clusters that don't use Availability Zones.
     */
    Standard(com.pulumi.azurenative.containerservice.enums.ManagedClusterSKUTier.Standard),

    /**
     * The cluster management is free, but charged for VM, storage, and networking usage. Best for experimenting, learning, simple testing, or workloads with fewer than 10 nodes. Not recommended for production use cases.
     */
    Free(com.pulumi.azurenative.containerservice.enums.ManagedClusterSKUTier.Free),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.ManagedClusterSKUTier =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.ManagedClusterSKUTier):
            ManagedClusterSKUTier = ManagedClusterSKUTier.values().first { it.javaValue == javaType }
    }
}
