@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.AgentPoolUpgradeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings for upgrading an agentpool
 * @property maxSurge This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see: https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
 */
public data class AgentPoolUpgradeSettingsArgs(
    public val maxSurge: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.AgentPoolUpgradeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.AgentPoolUpgradeSettingsArgs =
        com.pulumi.azurenative.containerservice.inputs.AgentPoolUpgradeSettingsArgs.builder()
            .maxSurge(maxSurge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPoolUpgradeSettingsArgs].
 */
@PulumiTagMarker
public class AgentPoolUpgradeSettingsArgsBuilder internal constructor() {
    private var maxSurge: Output<String>? = null

    /**
     * @param value This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see: https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
     */
    @JvmName("qxkxjxvmfwxqfnix")
    public suspend fun maxSurge(`value`: Output<String>) {
        this.maxSurge = value
    }

    /**
     * @param value This can either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the default is 1. For more information, including best practices, see: https://docs.microsoft.com/azure/aks/upgrade-cluster#customize-node-surge-upgrade
     */
    @JvmName("eqeqludehthphvow")
    public suspend fun maxSurge(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSurge = mapped
    }

    internal fun build(): AgentPoolUpgradeSettingsArgs = AgentPoolUpgradeSettingsArgs(
        maxSurge = maxSurge,
    )
}
