@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.AzureKeyVaultKmsArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.KeyVaultNetworkAccessTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Key Vault key management service settings for the security profile.
 * @property enabled Whether to enable Azure Key Vault key management service. The default is false.
 * @property keyId Identifier of Azure Key Vault key. See [key identifier format](https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name) for more details. When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When Azure Key Vault key management service is disabled, leave the field empty.
 * @property keyVaultNetworkAccess Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
 * @property keyVaultResourceId Resource ID of key vault. When keyVaultNetworkAccess is `Private`, this field is required and must be a valid resource ID. When keyVaultNetworkAccess is `Public`, leave the field empty.
 */
public data class AzureKeyVaultKmsArgs(
    public val enabled: Output<Boolean>? = null,
    public val keyId: Output<String>? = null,
    public val keyVaultNetworkAccess: Output<Either<String, KeyVaultNetworkAccessTypes>>? = null,
    public val keyVaultResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.AzureKeyVaultKmsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.AzureKeyVaultKmsArgs =
        com.pulumi.azurenative.containerservice.inputs.AzureKeyVaultKmsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .keyVaultNetworkAccess(
                keyVaultNetworkAccess?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .keyVaultResourceId(keyVaultResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureKeyVaultKmsArgs].
 */
@PulumiTagMarker
public class AzureKeyVaultKmsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var keyId: Output<String>? = null

    private var keyVaultNetworkAccess: Output<Either<String, KeyVaultNetworkAccessTypes>>? = null

    private var keyVaultResourceId: Output<String>? = null

    /**
     * @param value Whether to enable Azure Key Vault key management service. The default is false.
     */
    @JvmName("thwyixdfjnoloknh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Identifier of Azure Key Vault key. See [key identifier format](https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name) for more details. When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When Azure Key Vault key management service is disabled, leave the field empty.
     */
    @JvmName("yliahyxckdjvodwk")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
     */
    @JvmName("pcabxbrvtlqxrxhu")
    public suspend
    fun keyVaultNetworkAccess(`value`: Output<Either<String, KeyVaultNetworkAccessTypes>>) {
        this.keyVaultNetworkAccess = value
    }

    /**
     * @param value Resource ID of key vault. When keyVaultNetworkAccess is `Private`, this field is required and must be a valid resource ID. When keyVaultNetworkAccess is `Public`, leave the field empty.
     */
    @JvmName("xlnjrfatgssbbfxb")
    public suspend fun keyVaultResourceId(`value`: Output<String>) {
        this.keyVaultResourceId = value
    }

    /**
     * @param value Whether to enable Azure Key Vault key management service. The default is false.
     */
    @JvmName("uuooebtmjgtknvby")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Identifier of Azure Key Vault key. See [key identifier format](https://docs.microsoft.com/en-us/azure/key-vault/general/about-keys-secrets-certificates#vault-name-and-object-name) for more details. When Azure Key Vault key management service is enabled, this field is required and must be a valid key identifier. When Azure Key Vault key management service is disabled, leave the field empty.
     */
    @JvmName("pstsevlbrwarcygj")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
     */
    @JvmName("ormgjbsjfwjxbilm")
    public suspend fun keyVaultNetworkAccess(`value`: Either<String, KeyVaultNetworkAccessTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultNetworkAccess = mapped
    }

    /**
     * @param value Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
     */
    @JvmName("uftmvtucnpilfask")
    public fun keyVaultNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyVaultNetworkAccessTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultNetworkAccess = mapped
    }

    /**
     * @param value Network access of key vault. The possible values are `Public` and `Private`. `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public access and enables private link. The default value is `Public`.
     */
    @JvmName("srljlwtlqosqyecp")
    public fun keyVaultNetworkAccess(`value`: KeyVaultNetworkAccessTypes) {
        val toBeMapped = Either.ofRight<String, KeyVaultNetworkAccessTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultNetworkAccess = mapped
    }

    /**
     * @param value Resource ID of key vault. When keyVaultNetworkAccess is `Private`, this field is required and must be a valid resource ID. When keyVaultNetworkAccess is `Public`, leave the field empty.
     */
    @JvmName("cabbllokbpgmhpet")
    public suspend fun keyVaultResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultResourceId = mapped
    }

    internal fun build(): AzureKeyVaultKmsArgs = AzureKeyVaultKmsArgs(
        enabled = enabled,
        keyId = keyId,
        keyVaultNetworkAccess = keyVaultNetworkAccess,
        keyVaultResourceId = keyVaultResourceId,
    )
}
