@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.IpFamily
import com.pulumi.azurenative.containerservice.kotlin.enums.LoadBalancerSku
import com.pulumi.azurenative.containerservice.kotlin.enums.NetworkDataplane
import com.pulumi.azurenative.containerservice.kotlin.enums.NetworkMode
import com.pulumi.azurenative.containerservice.kotlin.enums.NetworkPlugin
import com.pulumi.azurenative.containerservice.kotlin.enums.NetworkPluginMode
import com.pulumi.azurenative.containerservice.kotlin.enums.NetworkPolicy
import com.pulumi.azurenative.containerservice.kotlin.enums.OutboundType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Profile of network configuration.
 * @property dnsServiceIP An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
 * @property ipFamilies IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
 * @property loadBalancerProfile Profile of the cluster load balancer.
 * @property loadBalancerSku The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
 * @property natGatewayProfile Profile of the cluster NAT gateway.
 * @property networkDataplane Network dataplane used in the Kubernetes cluster.
 * @property networkMode This cannot be specified if networkPlugin is anything other than 'azure'.
 * @property networkPlugin Network plugin used for building the Kubernetes network.
 * @property networkPluginMode The mode the network plugin should use.
 * @property networkPolicy Network policy used for building the Kubernetes network.
 * @property outboundType This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
 * @property podCidr A CIDR notation IP range from which to assign pod IPs when kubenet is used.
 * @property podCidrs One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 * @property serviceCidr A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
 * @property serviceCidrs One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
 */
public data class ContainerServiceNetworkProfileArgs(
    public val dnsServiceIP: Output<String>? = null,
    public val ipFamilies: Output<List<Either<String, IpFamily>>>? = null,
    public val loadBalancerProfile: Output<ManagedClusterLoadBalancerProfileArgs>? = null,
    public val loadBalancerSku: Output<Either<String, LoadBalancerSku>>? = null,
    public val natGatewayProfile: Output<ManagedClusterNATGatewayProfileArgs>? = null,
    public val networkDataplane: Output<Either<String, NetworkDataplane>>? = null,
    public val networkMode: Output<Either<String, NetworkMode>>? = null,
    public val networkPlugin: Output<Either<String, NetworkPlugin>>? = null,
    public val networkPluginMode: Output<Either<String, NetworkPluginMode>>? = null,
    public val networkPolicy: Output<Either<String, NetworkPolicy>>? = null,
    public val outboundType: Output<Either<String, OutboundType>>? = null,
    public val podCidr: Output<String>? = null,
    public val podCidrs: Output<List<String>>? = null,
    public val serviceCidr: Output<String>? = null,
    public val serviceCidrs: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ContainerServiceNetworkProfileArgs.builder()
            .dnsServiceIP(dnsServiceIP?.applyValue({ args0 -> args0 }))
            .ipFamilies(
                ipFamilies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .loadBalancerProfile(
                loadBalancerProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .loadBalancerSku(
                loadBalancerSku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .natGatewayProfile(natGatewayProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkDataplane(
                networkDataplane?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkMode(
                networkMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkPlugin(
                networkPlugin?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkPluginMode(
                networkPluginMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .networkPolicy(
                networkPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .outboundType(
                outboundType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .podCidr(podCidr?.applyValue({ args0 -> args0 }))
            .podCidrs(podCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .serviceCidrs(serviceCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ContainerServiceNetworkProfileArgs].
 */
@PulumiTagMarker
public class ContainerServiceNetworkProfileArgsBuilder internal constructor() {
    private var dnsServiceIP: Output<String>? = null

    private var ipFamilies: Output<List<Either<String, IpFamily>>>? = null

    private var loadBalancerProfile: Output<ManagedClusterLoadBalancerProfileArgs>? = null

    private var loadBalancerSku: Output<Either<String, LoadBalancerSku>>? = null

    private var natGatewayProfile: Output<ManagedClusterNATGatewayProfileArgs>? = null

    private var networkDataplane: Output<Either<String, NetworkDataplane>>? = null

    private var networkMode: Output<Either<String, NetworkMode>>? = null

    private var networkPlugin: Output<Either<String, NetworkPlugin>>? = null

    private var networkPluginMode: Output<Either<String, NetworkPluginMode>>? = null

    private var networkPolicy: Output<Either<String, NetworkPolicy>>? = null

    private var outboundType: Output<Either<String, OutboundType>>? = null

    private var podCidr: Output<String>? = null

    private var podCidrs: Output<List<String>>? = null

    private var serviceCidr: Output<String>? = null

    private var serviceCidrs: Output<List<String>>? = null

    /**
     * @param value An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
     */
    @JvmName("scwoosfqelkhlkuy")
    public suspend fun dnsServiceIP(`value`: Output<String>) {
        this.dnsServiceIP = value
    }

    /**
     * @param value IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
     */
    @JvmName("duejlxlvptmbkebg")
    public suspend fun ipFamilies(`value`: Output<List<Either<String, IpFamily>>>) {
        this.ipFamilies = value
    }

    @JvmName("qdajdwymmisgxtpu")
    public suspend fun ipFamilies(vararg values: Output<Either<String, IpFamily>>) {
        this.ipFamilies = Output.all(values.asList())
    }

    /**
     * @param values IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
     */
    @JvmName("gwhkvkydjhonkxpa")
    public suspend fun ipFamilies(values: List<Output<Either<String, IpFamily>>>) {
        this.ipFamilies = Output.all(values)
    }

    /**
     * @param value Profile of the cluster load balancer.
     */
    @JvmName("winiouutgojrycio")
    public suspend fun loadBalancerProfile(`value`: Output<ManagedClusterLoadBalancerProfileArgs>) {
        this.loadBalancerProfile = value
    }

    /**
     * @param value The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
     */
    @JvmName("uuisfewfvlnnwdui")
    public suspend fun loadBalancerSku(`value`: Output<Either<String, LoadBalancerSku>>) {
        this.loadBalancerSku = value
    }

    /**
     * @param value Profile of the cluster NAT gateway.
     */
    @JvmName("qkglrxbyyghyjlfe")
    public suspend fun natGatewayProfile(`value`: Output<ManagedClusterNATGatewayProfileArgs>) {
        this.natGatewayProfile = value
    }

    /**
     * @param value Network dataplane used in the Kubernetes cluster.
     */
    @JvmName("htgrpkxcaivfmpsb")
    public suspend fun networkDataplane(`value`: Output<Either<String, NetworkDataplane>>) {
        this.networkDataplane = value
    }

    /**
     * @param value This cannot be specified if networkPlugin is anything other than 'azure'.
     */
    @JvmName("mmxdptucfanfyoxu")
    public suspend fun networkMode(`value`: Output<Either<String, NetworkMode>>) {
        this.networkMode = value
    }

    /**
     * @param value Network plugin used for building the Kubernetes network.
     */
    @JvmName("gjmnoppcelgumgpq")
    public suspend fun networkPlugin(`value`: Output<Either<String, NetworkPlugin>>) {
        this.networkPlugin = value
    }

    /**
     * @param value The mode the network plugin should use.
     */
    @JvmName("esxmdyrblcibmjap")
    public suspend fun networkPluginMode(`value`: Output<Either<String, NetworkPluginMode>>) {
        this.networkPluginMode = value
    }

    /**
     * @param value Network policy used for building the Kubernetes network.
     */
    @JvmName("prduaabntbddotca")
    public suspend fun networkPolicy(`value`: Output<Either<String, NetworkPolicy>>) {
        this.networkPolicy = value
    }

    /**
     * @param value This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
     */
    @JvmName("yqxjdbsioewjvdbb")
    public suspend fun outboundType(`value`: Output<Either<String, OutboundType>>) {
        this.outboundType = value
    }

    /**
     * @param value A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     */
    @JvmName("biduibelsyxbwstn")
    public suspend fun podCidr(`value`: Output<String>) {
        this.podCidr = value
    }

    /**
     * @param value One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("yfspqgwxommotpqx")
    public suspend fun podCidrs(`value`: Output<List<String>>) {
        this.podCidrs = value
    }

    @JvmName("hyfsucqjhhrahxkv")
    public suspend fun podCidrs(vararg values: Output<String>) {
        this.podCidrs = Output.all(values.asList())
    }

    /**
     * @param values One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("mqbwjgeefkanhhjc")
    public suspend fun podCidrs(values: List<Output<String>>) {
        this.podCidrs = Output.all(values)
    }

    /**
     * @param value A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
     */
    @JvmName("rkjouillgihkydng")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("rgmgftuksvwbtysg")
    public suspend fun serviceCidrs(`value`: Output<List<String>>) {
        this.serviceCidrs = value
    }

    @JvmName("pynqdthyuesgiuxe")
    public suspend fun serviceCidrs(vararg values: Output<String>) {
        this.serviceCidrs = Output.all(values.asList())
    }

    /**
     * @param values One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("ddjiiosfeimmcnrh")
    public suspend fun serviceCidrs(values: List<Output<String>>) {
        this.serviceCidrs = Output.all(values)
    }

    /**
     * @param value An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
     */
    @JvmName("ejgujjqsvtdelbeu")
    public suspend fun dnsServiceIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServiceIP = mapped
    }

    /**
     * @param value IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
     */
    @JvmName("qxvbnjncrrhedhmb")
    public suspend fun ipFamilies(`value`: List<Either<String, IpFamily>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipFamilies = mapped
    }

    /**
     * @param values IP families are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
     */
    @JvmName("glqubpucfreybcxb")
    public suspend fun ipFamilies(vararg values: Either<String, IpFamily>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipFamilies = mapped
    }

    /**
     * @param value Profile of the cluster load balancer.
     */
    @JvmName("dqriypqxlptpbqxn")
    public suspend fun loadBalancerProfile(`value`: ManagedClusterLoadBalancerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerProfile = mapped
    }

    /**
     * @param argument Profile of the cluster load balancer.
     */
    @JvmName("dcvnecjnahcauneh")
    public suspend
    fun loadBalancerProfile(argument: suspend ManagedClusterLoadBalancerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterLoadBalancerProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerProfile = mapped
    }

    /**
     * @param value The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
     */
    @JvmName("fgqgbjmcouhkolpm")
    public suspend fun loadBalancerSku(`value`: Either<String, LoadBalancerSku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSku = mapped
    }

    /**
     * @param value The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
     */
    @JvmName("lspkgrmiyagyknob")
    public fun loadBalancerSku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerSku = mapped
    }

    /**
     * @param value The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs.
     */
    @JvmName("tpdyepchthwywqcq")
    public fun loadBalancerSku(`value`: LoadBalancerSku) {
        val toBeMapped = Either.ofRight<String, LoadBalancerSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerSku = mapped
    }

    /**
     * @param value Profile of the cluster NAT gateway.
     */
    @JvmName("nyoqbufumjcfpeme")
    public suspend fun natGatewayProfile(`value`: ManagedClusterNATGatewayProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayProfile = mapped
    }

    /**
     * @param argument Profile of the cluster NAT gateway.
     */
    @JvmName("rkvgcchcudmwmgyd")
    public suspend
    fun natGatewayProfile(argument: suspend ManagedClusterNATGatewayProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterNATGatewayProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGatewayProfile = mapped
    }

    /**
     * @param value Network dataplane used in the Kubernetes cluster.
     */
    @JvmName("kvxeiueoqtrljoyt")
    public suspend fun networkDataplane(`value`: Either<String, NetworkDataplane>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkDataplane = mapped
    }

    /**
     * @param value Network dataplane used in the Kubernetes cluster.
     */
    @JvmName("vkntwnqseppfhtxh")
    public fun networkDataplane(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkDataplane>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDataplane = mapped
    }

    /**
     * @param value Network dataplane used in the Kubernetes cluster.
     */
    @JvmName("rcrqmympvbylisjb")
    public fun networkDataplane(`value`: NetworkDataplane) {
        val toBeMapped = Either.ofRight<String, NetworkDataplane>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkDataplane = mapped
    }

    /**
     * @param value This cannot be specified if networkPlugin is anything other than 'azure'.
     */
    @JvmName("seymmnqlxnopdgcs")
    public suspend fun networkMode(`value`: Either<String, NetworkMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkMode = mapped
    }

    /**
     * @param value This cannot be specified if networkPlugin is anything other than 'azure'.
     */
    @JvmName("jkhaatwgdajxslck")
    public fun networkMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkMode = mapped
    }

    /**
     * @param value This cannot be specified if networkPlugin is anything other than 'azure'.
     */
    @JvmName("ivycrogyeoynunhn")
    public fun networkMode(`value`: NetworkMode) {
        val toBeMapped = Either.ofRight<String, NetworkMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkMode = mapped
    }

    /**
     * @param value Network plugin used for building the Kubernetes network.
     */
    @JvmName("canxbaaqjbwhqwqq")
    public suspend fun networkPlugin(`value`: Either<String, NetworkPlugin>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkPlugin = mapped
    }

    /**
     * @param value Network plugin used for building the Kubernetes network.
     */
    @JvmName("onvfnkaluyrmdafp")
    public fun networkPlugin(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkPlugin>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPlugin = mapped
    }

    /**
     * @param value Network plugin used for building the Kubernetes network.
     */
    @JvmName("kdntcfcapibvessn")
    public fun networkPlugin(`value`: NetworkPlugin) {
        val toBeMapped = Either.ofRight<String, NetworkPlugin>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPlugin = mapped
    }

    /**
     * @param value The mode the network plugin should use.
     */
    @JvmName("fvtoqowaohtbqibl")
    public suspend fun networkPluginMode(`value`: Either<String, NetworkPluginMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkPluginMode = mapped
    }

    /**
     * @param value The mode the network plugin should use.
     */
    @JvmName("vjbtlvywokpnqnwd")
    public fun networkPluginMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkPluginMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPluginMode = mapped
    }

    /**
     * @param value The mode the network plugin should use.
     */
    @JvmName("saivqrpfyeeuhlac")
    public fun networkPluginMode(`value`: NetworkPluginMode) {
        val toBeMapped = Either.ofRight<String, NetworkPluginMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPluginMode = mapped
    }

    /**
     * @param value Network policy used for building the Kubernetes network.
     */
    @JvmName("jeskwepwxnsltpdq")
    public suspend fun networkPolicy(`value`: Either<String, NetworkPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkPolicy = mapped
    }

    /**
     * @param value Network policy used for building the Kubernetes network.
     */
    @JvmName("cjtvdbigqufaypqp")
    public fun networkPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPolicy = mapped
    }

    /**
     * @param value Network policy used for building the Kubernetes network.
     */
    @JvmName("cdlhdemguomclvip")
    public fun networkPolicy(`value`: NetworkPolicy) {
        val toBeMapped = Either.ofRight<String, NetworkPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPolicy = mapped
    }

    /**
     * @param value This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
     */
    @JvmName("tibenrihpejqtioq")
    public suspend fun outboundType(`value`: Either<String, OutboundType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundType = mapped
    }

    /**
     * @param value This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
     */
    @JvmName("uytonvxxxpofldkq")
    public fun outboundType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutboundType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outboundType = mapped
    }

    /**
     * @param value This can only be set at cluster creation time and cannot be changed later. For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
     */
    @JvmName("mugvssolvkhndqnp")
    public fun outboundType(`value`: OutboundType) {
        val toBeMapped = Either.ofRight<String, OutboundType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outboundType = mapped
    }

    /**
     * @param value A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     */
    @JvmName("kpycmjsebmcmypbh")
    public suspend fun podCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidr = mapped
    }

    /**
     * @param value One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("mjuavsmmoptuvfqd")
    public suspend fun podCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidrs = mapped
    }

    /**
     * @param values One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    @JvmName("aiocnfixhmmvjbql")
    public suspend fun podCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.podCidrs = mapped
    }

    /**
     * @param value A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
     */
    @JvmName("qntotijqpwraegcp")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("veccleuckvpqamtn")
    public suspend fun serviceCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidrs = mapped
    }

    /**
     * @param values One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not overlap with any Subnet IP ranges.
     */
    @JvmName("saubenqnjsqsflvd")
    public suspend fun serviceCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceCidrs = mapped
    }

    internal fun build(): ContainerServiceNetworkProfileArgs = ContainerServiceNetworkProfileArgs(
        dnsServiceIP = dnsServiceIP,
        ipFamilies = ipFamilies,
        loadBalancerProfile = loadBalancerProfile,
        loadBalancerSku = loadBalancerSku,
        natGatewayProfile = natGatewayProfile,
        networkDataplane = networkDataplane,
        networkMode = networkMode,
        networkPlugin = networkPlugin,
        networkPluginMode = networkPluginMode,
        networkPolicy = networkPolicy,
        outboundType = outboundType,
        podCidr = podCidr,
        podCidrs = podCidrs,
        serviceCidr = serviceCidr,
        serviceCidrs = serviceCidrs,
    )
}
