@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshPublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains information about SSH certificate public key data.
 * @property keyData Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
 */
public data class ContainerServiceSshPublicKeyArgs(
    public val keyData: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshPublicKeyArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshPublicKeyArgs =
        com.pulumi.azurenative.containerservice.inputs.ContainerServiceSshPublicKeyArgs.builder()
            .keyData(keyData.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerServiceSshPublicKeyArgs].
 */
@PulumiTagMarker
public class ContainerServiceSshPublicKeyArgsBuilder internal constructor() {
    private var keyData: Output<String>? = null

    /**
     * @param value Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
     */
    @JvmName("vspqiwutqcvlyxvg")
    public suspend fun keyData(`value`: Output<String>) {
        this.keyData = value
    }

    /**
     * @param value Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
     */
    @JvmName("cnbgefiiobuuejnp")
    public suspend fun keyData(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyData = mapped
    }

    internal fun build(): ContainerServiceSshPublicKeyArgs = ContainerServiceSshPublicKeyArgs(
        keyData = keyData ?: throw PulumiNullFieldException("keyData"),
    )
}
