@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterHTTPProxyConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cluster HTTP proxy configuration.
 * @property httpProxy The HTTP proxy server endpoint to use.
 * @property httpsProxy The HTTPS proxy server endpoint to use.
 * @property noProxy The endpoints that should not go through proxy.
 * @property trustedCa Alternative CA cert to use for connecting to proxy servers.
 */
public data class ManagedClusterHTTPProxyConfigArgs(
    public val httpProxy: Output<String>? = null,
    public val httpsProxy: Output<String>? = null,
    public val noProxy: Output<List<String>>? = null,
    public val trustedCa: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterHTTPProxyConfigArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterHTTPProxyConfigArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterHTTPProxyConfigArgs.builder()
            .httpProxy(httpProxy?.applyValue({ args0 -> args0 }))
            .httpsProxy(httpsProxy?.applyValue({ args0 -> args0 }))
            .noProxy(noProxy?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .trustedCa(trustedCa?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterHTTPProxyConfigArgs].
 */
@PulumiTagMarker
public class ManagedClusterHTTPProxyConfigArgsBuilder internal constructor() {
    private var httpProxy: Output<String>? = null

    private var httpsProxy: Output<String>? = null

    private var noProxy: Output<List<String>>? = null

    private var trustedCa: Output<String>? = null

    /**
     * @param value The HTTP proxy server endpoint to use.
     */
    @JvmName("gmmqxtnyjjemgdoe")
    public suspend fun httpProxy(`value`: Output<String>) {
        this.httpProxy = value
    }

    /**
     * @param value The HTTPS proxy server endpoint to use.
     */
    @JvmName("ewjykfvnmvavcweo")
    public suspend fun httpsProxy(`value`: Output<String>) {
        this.httpsProxy = value
    }

    /**
     * @param value The endpoints that should not go through proxy.
     */
    @JvmName("uxjmgqlhogkedghs")
    public suspend fun noProxy(`value`: Output<List<String>>) {
        this.noProxy = value
    }

    @JvmName("dvlegabpngbldynf")
    public suspend fun noProxy(vararg values: Output<String>) {
        this.noProxy = Output.all(values.asList())
    }

    /**
     * @param values The endpoints that should not go through proxy.
     */
    @JvmName("tndvevkahcbndqdw")
    public suspend fun noProxy(values: List<Output<String>>) {
        this.noProxy = Output.all(values)
    }

    /**
     * @param value Alternative CA cert to use for connecting to proxy servers.
     */
    @JvmName("jghoeunmsvjeclyy")
    public suspend fun trustedCa(`value`: Output<String>) {
        this.trustedCa = value
    }

    /**
     * @param value The HTTP proxy server endpoint to use.
     */
    @JvmName("dtmsmcxlxxgnejci")
    public suspend fun httpProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxy = mapped
    }

    /**
     * @param value The HTTPS proxy server endpoint to use.
     */
    @JvmName("ooayqhnjftqcdbcl")
    public suspend fun httpsProxy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsProxy = mapped
    }

    /**
     * @param value The endpoints that should not go through proxy.
     */
    @JvmName("elwiydgjrsnletxj")
    public suspend fun noProxy(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noProxy = mapped
    }

    /**
     * @param values The endpoints that should not go through proxy.
     */
    @JvmName("gsrybknjoxgcaeyp")
    public suspend fun noProxy(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noProxy = mapped
    }

    /**
     * @param value Alternative CA cert to use for connecting to proxy servers.
     */
    @JvmName("uxrmhxxidnsoppup")
    public suspend fun trustedCa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCa = mapped
    }

    internal fun build(): ManagedClusterHTTPProxyConfigArgs = ManagedClusterHTTPProxyConfigArgs(
        httpProxy = httpProxy,
        httpsProxy = httpsProxy,
        noProxy = noProxy,
        trustedCa = trustedCa,
    )
}
