@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details about the pod identity assigned to the Managed Cluster.
 * @property bindingSelector The binding selector to use for the AzureIdentityBinding resource.
 * @property identity The user assigned identity details.
 * @property name The name of the pod identity.
 * @property namespace The namespace of the pod identity.
 */
public data class ManagedClusterPodIdentityArgs(
    public val bindingSelector: Output<String>? = null,
    public val identity: Output<UserAssignedIdentityArgs>,
    public val name: Output<String>,
    public val namespace: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterPodIdentityArgs.builder()
            .bindingSelector(bindingSelector?.applyValue({ args0 -> args0 }))
            .identity(identity.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterPodIdentityArgs].
 */
@PulumiTagMarker
public class ManagedClusterPodIdentityArgsBuilder internal constructor() {
    private var bindingSelector: Output<String>? = null

    private var identity: Output<UserAssignedIdentityArgs>? = null

    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value The binding selector to use for the AzureIdentityBinding resource.
     */
    @JvmName("wnljilwyigwjnqjp")
    public suspend fun bindingSelector(`value`: Output<String>) {
        this.bindingSelector = value
    }

    /**
     * @param value The user assigned identity details.
     */
    @JvmName("iteitikektjoyikm")
    public suspend fun identity(`value`: Output<UserAssignedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the pod identity.
     */
    @JvmName("ljuidtaaaferlrlh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The namespace of the pod identity.
     */
    @JvmName("lvbxvsjuovuamukl")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The binding selector to use for the AzureIdentityBinding resource.
     */
    @JvmName("hsaytjfqitdifsfm")
    public suspend fun bindingSelector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingSelector = mapped
    }

    /**
     * @param value The user assigned identity details.
     */
    @JvmName("psgpqlunnsmqwmma")
    public suspend fun identity(`value`: UserAssignedIdentityArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The user assigned identity details.
     */
    @JvmName("dbfeerhsgyctmehe")
    public suspend fun identity(argument: suspend UserAssignedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the pod identity.
     */
    @JvmName("rvpoqycvunbmfcqa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The namespace of the pod identity.
     */
    @JvmName("tswsfnldxxsrhman")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): ManagedClusterPodIdentityArgs = ManagedClusterPodIdentityArgs(
        bindingSelector = bindingSelector,
        identity = identity ?: throw PulumiNullFieldException("identity"),
        name = name ?: throw PulumiNullFieldException("name"),
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
    )
}
