@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.Expander
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters to be applied to the cluster-autoscaler when enabled
 * @property balanceSimilarNodeGroups Valid values are 'true' and 'false'
 * @property expander If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
 * @property maxEmptyBulkDelete The default is 10.
 * @property maxGracefulTerminationSec The default is 600.
 * @property maxNodeProvisionTime The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property maxTotalUnreadyPercentage The default is 45. The maximum is 100 and the minimum is 0.
 * @property newPodScaleUpDelay For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
 * @property okTotalUnreadyCount This must be an integer. The default is 3.
 * @property scaleDownDelayAfterAdd The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownDelayAfterDelete The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownDelayAfterFailure The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownUnneededTime The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownUnreadyTime The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownUtilizationThreshold The default is '0.5'.
 * @property scanInterval The default is '10'. Values must be an integer number of seconds.
 * @property skipNodesWithLocalStorage The default is true.
 * @property skipNodesWithSystemPods The default is true.
 */
public data class ManagedClusterPropertiesAutoScalerProfileArgs(
    public val balanceSimilarNodeGroups: Output<String>? = null,
    public val expander: Output<Either<String, Expander>>? = null,
    public val maxEmptyBulkDelete: Output<String>? = null,
    public val maxGracefulTerminationSec: Output<String>? = null,
    public val maxNodeProvisionTime: Output<String>? = null,
    public val maxTotalUnreadyPercentage: Output<String>? = null,
    public val newPodScaleUpDelay: Output<String>? = null,
    public val okTotalUnreadyCount: Output<String>? = null,
    public val scaleDownDelayAfterAdd: Output<String>? = null,
    public val scaleDownDelayAfterDelete: Output<String>? = null,
    public val scaleDownDelayAfterFailure: Output<String>? = null,
    public val scaleDownUnneededTime: Output<String>? = null,
    public val scaleDownUnreadyTime: Output<String>? = null,
    public val scaleDownUtilizationThreshold: Output<String>? = null,
    public val scanInterval: Output<String>? = null,
    public val skipNodesWithLocalStorage: Output<String>? = null,
    public val skipNodesWithSystemPods: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterPropertiesAutoScalerProfileArgs.builder()
            .balanceSimilarNodeGroups(balanceSimilarNodeGroups?.applyValue({ args0 -> args0 }))
            .expander(
                expander?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maxEmptyBulkDelete(maxEmptyBulkDelete?.applyValue({ args0 -> args0 }))
            .maxGracefulTerminationSec(maxGracefulTerminationSec?.applyValue({ args0 -> args0 }))
            .maxNodeProvisionTime(maxNodeProvisionTime?.applyValue({ args0 -> args0 }))
            .maxTotalUnreadyPercentage(maxTotalUnreadyPercentage?.applyValue({ args0 -> args0 }))
            .newPodScaleUpDelay(newPodScaleUpDelay?.applyValue({ args0 -> args0 }))
            .okTotalUnreadyCount(okTotalUnreadyCount?.applyValue({ args0 -> args0 }))
            .scaleDownDelayAfterAdd(scaleDownDelayAfterAdd?.applyValue({ args0 -> args0 }))
            .scaleDownDelayAfterDelete(scaleDownDelayAfterDelete?.applyValue({ args0 -> args0 }))
            .scaleDownDelayAfterFailure(scaleDownDelayAfterFailure?.applyValue({ args0 -> args0 }))
            .scaleDownUnneededTime(scaleDownUnneededTime?.applyValue({ args0 -> args0 }))
            .scaleDownUnreadyTime(scaleDownUnreadyTime?.applyValue({ args0 -> args0 }))
            .scaleDownUtilizationThreshold(scaleDownUtilizationThreshold?.applyValue({ args0 -> args0 }))
            .scanInterval(scanInterval?.applyValue({ args0 -> args0 }))
            .skipNodesWithLocalStorage(skipNodesWithLocalStorage?.applyValue({ args0 -> args0 }))
            .skipNodesWithSystemPods(skipNodesWithSystemPods?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterPropertiesAutoScalerProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterPropertiesAutoScalerProfileArgsBuilder internal constructor() {
    private var balanceSimilarNodeGroups: Output<String>? = null

    private var expander: Output<Either<String, Expander>>? = null

    private var maxEmptyBulkDelete: Output<String>? = null

    private var maxGracefulTerminationSec: Output<String>? = null

    private var maxNodeProvisionTime: Output<String>? = null

    private var maxTotalUnreadyPercentage: Output<String>? = null

    private var newPodScaleUpDelay: Output<String>? = null

    private var okTotalUnreadyCount: Output<String>? = null

    private var scaleDownDelayAfterAdd: Output<String>? = null

    private var scaleDownDelayAfterDelete: Output<String>? = null

    private var scaleDownDelayAfterFailure: Output<String>? = null

    private var scaleDownUnneededTime: Output<String>? = null

    private var scaleDownUnreadyTime: Output<String>? = null

    private var scaleDownUtilizationThreshold: Output<String>? = null

    private var scanInterval: Output<String>? = null

    private var skipNodesWithLocalStorage: Output<String>? = null

    private var skipNodesWithSystemPods: Output<String>? = null

    /**
     * @param value Valid values are 'true' and 'false'
     */
    @JvmName("ikfhjykmkjgeakjr")
    public suspend fun balanceSimilarNodeGroups(`value`: Output<String>) {
        this.balanceSimilarNodeGroups = value
    }

    /**
     * @param value If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
     */
    @JvmName("tmvhutuxrtasewbd")
    public suspend fun expander(`value`: Output<Either<String, Expander>>) {
        this.expander = value
    }

    /**
     * @param value The default is 10.
     */
    @JvmName("fbuepamuknrawnyj")
    public suspend fun maxEmptyBulkDelete(`value`: Output<String>) {
        this.maxEmptyBulkDelete = value
    }

    /**
     * @param value The default is 600.
     */
    @JvmName("afvclxlfaxajkkpc")
    public suspend fun maxGracefulTerminationSec(`value`: Output<String>) {
        this.maxGracefulTerminationSec = value
    }

    /**
     * @param value The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("gexgnitcbaweaapq")
    public suspend fun maxNodeProvisionTime(`value`: Output<String>) {
        this.maxNodeProvisionTime = value
    }

    /**
     * @param value The default is 45. The maximum is 100 and the minimum is 0.
     */
    @JvmName("wwfqcfkvxojviscr")
    public suspend fun maxTotalUnreadyPercentage(`value`: Output<String>) {
        this.maxTotalUnreadyPercentage = value
    }

    /**
     * @param value For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
     */
    @JvmName("fueyclsovjmltnef")
    public suspend fun newPodScaleUpDelay(`value`: Output<String>) {
        this.newPodScaleUpDelay = value
    }

    /**
     * @param value This must be an integer. The default is 3.
     */
    @JvmName("lbtlnllextlhryvg")
    public suspend fun okTotalUnreadyCount(`value`: Output<String>) {
        this.okTotalUnreadyCount = value
    }

    /**
     * @param value The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("ofdfwnnespffqyxm")
    public suspend fun scaleDownDelayAfterAdd(`value`: Output<String>) {
        this.scaleDownDelayAfterAdd = value
    }

    /**
     * @param value The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("cbmrgtyiamdcmrvq")
    public suspend fun scaleDownDelayAfterDelete(`value`: Output<String>) {
        this.scaleDownDelayAfterDelete = value
    }

    /**
     * @param value The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("xwgtrnroxxaalssf")
    public suspend fun scaleDownDelayAfterFailure(`value`: Output<String>) {
        this.scaleDownDelayAfterFailure = value
    }

    /**
     * @param value The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("qaciaxeoawhrelbq")
    public suspend fun scaleDownUnneededTime(`value`: Output<String>) {
        this.scaleDownUnneededTime = value
    }

    /**
     * @param value The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("caiokcyhktcawbjd")
    public suspend fun scaleDownUnreadyTime(`value`: Output<String>) {
        this.scaleDownUnreadyTime = value
    }

    /**
     * @param value The default is '0.5'.
     */
    @JvmName("qgturqsqerjncrqd")
    public suspend fun scaleDownUtilizationThreshold(`value`: Output<String>) {
        this.scaleDownUtilizationThreshold = value
    }

    /**
     * @param value The default is '10'. Values must be an integer number of seconds.
     */
    @JvmName("ncwbojskryclxxko")
    public suspend fun scanInterval(`value`: Output<String>) {
        this.scanInterval = value
    }

    /**
     * @param value The default is true.
     */
    @JvmName("txwsmhdtkdcupbqc")
    public suspend fun skipNodesWithLocalStorage(`value`: Output<String>) {
        this.skipNodesWithLocalStorage = value
    }

    /**
     * @param value The default is true.
     */
    @JvmName("cyeankmjwuwhfjyg")
    public suspend fun skipNodesWithSystemPods(`value`: Output<String>) {
        this.skipNodesWithSystemPods = value
    }

    /**
     * @param value Valid values are 'true' and 'false'
     */
    @JvmName("eohhpdkrsoxmmvvb")
    public suspend fun balanceSimilarNodeGroups(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.balanceSimilarNodeGroups = mapped
    }

    /**
     * @param value If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
     */
    @JvmName("woupjsryhlclydxn")
    public suspend fun expander(`value`: Either<String, Expander>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expander = mapped
    }

    /**
     * @param value If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
     */
    @JvmName("mgtgtyvlninxuvaq")
    public fun expander(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Expander>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expander = mapped
    }

    /**
     * @param value If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
     */
    @JvmName("drrqlsdrpjwiymxm")
    public fun expander(`value`: Expander) {
        val toBeMapped = Either.ofRight<String, Expander>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expander = mapped
    }

    /**
     * @param value The default is 10.
     */
    @JvmName("nirptlkitqlmefvc")
    public suspend fun maxEmptyBulkDelete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEmptyBulkDelete = mapped
    }

    /**
     * @param value The default is 600.
     */
    @JvmName("yhccufudwnhapuct")
    public suspend fun maxGracefulTerminationSec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxGracefulTerminationSec = mapped
    }

    /**
     * @param value The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("seotqyoreeugdxeh")
    public suspend fun maxNodeProvisionTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxNodeProvisionTime = mapped
    }

    /**
     * @param value The default is 45. The maximum is 100 and the minimum is 0.
     */
    @JvmName("xbpegaioirtocxpj")
    public suspend fun maxTotalUnreadyPercentage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTotalUnreadyPercentage = mapped
    }

    /**
     * @param value For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
     */
    @JvmName("olxiojxwbwrlovqi")
    public suspend fun newPodScaleUpDelay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newPodScaleUpDelay = mapped
    }

    /**
     * @param value This must be an integer. The default is 3.
     */
    @JvmName("dxxvevrmmpwcvlun")
    public suspend fun okTotalUnreadyCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.okTotalUnreadyCount = mapped
    }

    /**
     * @param value The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("rofhfrdhhofeorgq")
    public suspend fun scaleDownDelayAfterAdd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownDelayAfterAdd = mapped
    }

    /**
     * @param value The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("bybugoqwehjnkhfi")
    public suspend fun scaleDownDelayAfterDelete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownDelayAfterDelete = mapped
    }

    /**
     * @param value The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("ijycmhpvyaeckhih")
    public suspend fun scaleDownDelayAfterFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownDelayAfterFailure = mapped
    }

    /**
     * @param value The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("fiaxwlytnauyajrd")
    public suspend fun scaleDownUnneededTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownUnneededTime = mapped
    }

    /**
     * @param value The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
     */
    @JvmName("halfuffgxnxrqkap")
    public suspend fun scaleDownUnreadyTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownUnreadyTime = mapped
    }

    /**
     * @param value The default is '0.5'.
     */
    @JvmName("lrqxutmlybmaqvul")
    public suspend fun scaleDownUtilizationThreshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleDownUtilizationThreshold = mapped
    }

    /**
     * @param value The default is '10'. Values must be an integer number of seconds.
     */
    @JvmName("rhpfqjqmrneeepay")
    public suspend fun scanInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanInterval = mapped
    }

    /**
     * @param value The default is true.
     */
    @JvmName("tgdnvhsqubkukkih")
    public suspend fun skipNodesWithLocalStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipNodesWithLocalStorage = mapped
    }

    /**
     * @param value The default is true.
     */
    @JvmName("aayqyuwsvawesryi")
    public suspend fun skipNodesWithSystemPods(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipNodesWithSystemPods = mapped
    }

    internal fun build(): ManagedClusterPropertiesAutoScalerProfileArgs =
        ManagedClusterPropertiesAutoScalerProfileArgs(
            balanceSimilarNodeGroups = balanceSimilarNodeGroups,
            expander = expander,
            maxEmptyBulkDelete = maxEmptyBulkDelete,
            maxGracefulTerminationSec = maxGracefulTerminationSec,
            maxNodeProvisionTime = maxNodeProvisionTime,
            maxTotalUnreadyPercentage = maxTotalUnreadyPercentage,
            newPodScaleUpDelay = newPodScaleUpDelay,
            okTotalUnreadyCount = okTotalUnreadyCount,
            scaleDownDelayAfterAdd = scaleDownDelayAfterAdd,
            scaleDownDelayAfterDelete = scaleDownDelayAfterDelete,
            scaleDownDelayAfterFailure = scaleDownDelayAfterFailure,
            scaleDownUnneededTime = scaleDownUnneededTime,
            scaleDownUnreadyTime = scaleDownUnreadyTime,
            scaleDownUtilizationThreshold = scaleDownUtilizationThreshold,
            scanInterval = scanInterval,
            skipNodesWithLocalStorage = skipNodesWithLocalStorage,
            skipNodesWithSystemPods = skipNodesWithSystemPods,
        )
}
