@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Microsoft Defender settings for the security profile threat detection.
 * @property enabled Whether to enable Defender threat detection
 */
public data class ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs(
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs].
 */
@PulumiTagMarker
public class ManagedClusterSecurityProfileDefenderSecurityMonitoringArgsBuilder internal
constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable Defender threat detection
     */
    @JvmName("hvthambdsmomucoe")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable Defender threat detection
     */
    @JvmName("toqavyvrdlhufrfa")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs =
        ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs(
            enabled = enabled,
        )
}
