@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about a service principal identity for the cluster to use for manipulating Azure APIs.
 * @property clientId The ID for the service principal.
 * @property secret The secret password associated with the service principal in plain text.
 */
public data class ManagedClusterServicePrincipalProfileArgs(
    public val clientId: Output<String>,
    public val secret: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterServicePrincipalProfileArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .secret(secret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterServicePrincipalProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterServicePrincipalProfileArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var secret: Output<String>? = null

    /**
     * @param value The ID for the service principal.
     */
    @JvmName("shqjidnbtddjcgda")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The secret password associated with the service principal in plain text.
     */
    @JvmName("ivpuulaiyunnjdxi")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value The ID for the service principal.
     */
    @JvmName("wousjbyckynjhqhf")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The secret password associated with the service principal in plain text.
     */
    @JvmName("nhlgoguikmqpvddx")
    public suspend fun secret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    internal fun build(): ManagedClusterServicePrincipalProfileArgs =
        ManagedClusterServicePrincipalProfileArgs(
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            secret = secret,
        )
}
