@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage profile for the container service cluster.
 * @property blobCSIDriver AzureBlob CSI Driver settings for the storage profile.
 * @property diskCSIDriver AzureDisk CSI Driver settings for the storage profile.
 * @property fileCSIDriver AzureFile CSI Driver settings for the storage profile.
 * @property snapshotController Snapshot Controller settings for the storage profile.
 */
public data class ManagedClusterStorageProfileArgs(
    public val blobCSIDriver: Output<ManagedClusterStorageProfileBlobCSIDriverArgs>? = null,
    public val diskCSIDriver: Output<ManagedClusterStorageProfileDiskCSIDriverArgs>? = null,
    public val fileCSIDriver: Output<ManagedClusterStorageProfileFileCSIDriverArgs>? = null,
    public val snapshotController: Output<ManagedClusterStorageProfileSnapshotControllerArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileArgs.builder()
            .blobCSIDriver(blobCSIDriver?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskCSIDriver(diskCSIDriver?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileCSIDriver(fileCSIDriver?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snapshotController(
                snapshotController?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterStorageProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterStorageProfileArgsBuilder internal constructor() {
    private var blobCSIDriver: Output<ManagedClusterStorageProfileBlobCSIDriverArgs>? = null

    private var diskCSIDriver: Output<ManagedClusterStorageProfileDiskCSIDriverArgs>? = null

    private var fileCSIDriver: Output<ManagedClusterStorageProfileFileCSIDriverArgs>? = null

    private var snapshotController: Output<ManagedClusterStorageProfileSnapshotControllerArgs>? = null

    /**
     * @param value AzureBlob CSI Driver settings for the storage profile.
     */
    @JvmName("cycllbqjegaovflk")
    public suspend fun blobCSIDriver(`value`: Output<ManagedClusterStorageProfileBlobCSIDriverArgs>) {
        this.blobCSIDriver = value
    }

    /**
     * @param value AzureDisk CSI Driver settings for the storage profile.
     */
    @JvmName("tsuxetduhicmejdp")
    public suspend fun diskCSIDriver(`value`: Output<ManagedClusterStorageProfileDiskCSIDriverArgs>) {
        this.diskCSIDriver = value
    }

    /**
     * @param value AzureFile CSI Driver settings for the storage profile.
     */
    @JvmName("bcdgmappsoguuipx")
    public suspend fun fileCSIDriver(`value`: Output<ManagedClusterStorageProfileFileCSIDriverArgs>) {
        this.fileCSIDriver = value
    }

    /**
     * @param value Snapshot Controller settings for the storage profile.
     */
    @JvmName("btstuaukenrxdlwe")
    public suspend
    fun snapshotController(`value`: Output<ManagedClusterStorageProfileSnapshotControllerArgs>) {
        this.snapshotController = value
    }

    /**
     * @param value AzureBlob CSI Driver settings for the storage profile.
     */
    @JvmName("jlertqwmskcsouvg")
    public suspend fun blobCSIDriver(`value`: ManagedClusterStorageProfileBlobCSIDriverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobCSIDriver = mapped
    }

    /**
     * @param argument AzureBlob CSI Driver settings for the storage profile.
     */
    @JvmName("vqqvyjjnbhulfiov")
    public suspend
    fun blobCSIDriver(argument: suspend ManagedClusterStorageProfileBlobCSIDriverArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterStorageProfileBlobCSIDriverArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.blobCSIDriver = mapped
    }

    /**
     * @param value AzureDisk CSI Driver settings for the storage profile.
     */
    @JvmName("qdgusqqweotrgswx")
    public suspend fun diskCSIDriver(`value`: ManagedClusterStorageProfileDiskCSIDriverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCSIDriver = mapped
    }

    /**
     * @param argument AzureDisk CSI Driver settings for the storage profile.
     */
    @JvmName("lhweomosltkvrdlp")
    public suspend
    fun diskCSIDriver(argument: suspend ManagedClusterStorageProfileDiskCSIDriverArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterStorageProfileDiskCSIDriverArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.diskCSIDriver = mapped
    }

    /**
     * @param value AzureFile CSI Driver settings for the storage profile.
     */
    @JvmName("pbgxyxmipsxqxnxi")
    public suspend fun fileCSIDriver(`value`: ManagedClusterStorageProfileFileCSIDriverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileCSIDriver = mapped
    }

    /**
     * @param argument AzureFile CSI Driver settings for the storage profile.
     */
    @JvmName("sdajpvujmqxfmadb")
    public suspend
    fun fileCSIDriver(argument: suspend ManagedClusterStorageProfileFileCSIDriverArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterStorageProfileFileCSIDriverArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fileCSIDriver = mapped
    }

    /**
     * @param value Snapshot Controller settings for the storage profile.
     */
    @JvmName("qhgoofmlemgkflec")
    public suspend
    fun snapshotController(`value`: ManagedClusterStorageProfileSnapshotControllerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotController = mapped
    }

    /**
     * @param argument Snapshot Controller settings for the storage profile.
     */
    @JvmName("ljovrunyrmmxjpar")
    public suspend
    fun snapshotController(argument: suspend ManagedClusterStorageProfileSnapshotControllerArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterStorageProfileSnapshotControllerArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.snapshotController = mapped
    }

    internal fun build(): ManagedClusterStorageProfileArgs = ManagedClusterStorageProfileArgs(
        blobCSIDriver = blobCSIDriver,
        diskCSIDriver = diskCSIDriver,
        fileCSIDriver = fileCSIDriver,
        snapshotController = snapshotController,
    )
}
