@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpdateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The update to be applied to the ManagedClusters.
 * @property upgrade The upgrade to apply to the ManagedClusters.
 */
public data class ManagedClusterUpdateArgs(
    public val upgrade: Output<ManagedClusterUpgradeSpecArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpdateArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpdateArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterUpdateArgs.builder()
            .upgrade(upgrade.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagedClusterUpdateArgs].
 */
@PulumiTagMarker
public class ManagedClusterUpdateArgsBuilder internal constructor() {
    private var upgrade: Output<ManagedClusterUpgradeSpecArgs>? = null

    /**
     * @param value The upgrade to apply to the ManagedClusters.
     */
    @JvmName("aucdeujwjkxkfudd")
    public suspend fun upgrade(`value`: Output<ManagedClusterUpgradeSpecArgs>) {
        this.upgrade = value
    }

    /**
     * @param value The upgrade to apply to the ManagedClusters.
     */
    @JvmName("cqytrriunrjqjbii")
    public suspend fun upgrade(`value`: ManagedClusterUpgradeSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upgrade = mapped
    }

    /**
     * @param argument The upgrade to apply to the ManagedClusters.
     */
    @JvmName("jbbbmykuyyknyfif")
    public suspend fun upgrade(argument: suspend ManagedClusterUpgradeSpecArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterUpgradeSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgrade = mapped
    }

    internal fun build(): ManagedClusterUpdateArgs = ManagedClusterUpdateArgs(
        upgrade = upgrade ?: throw PulumiNullFieldException("upgrade"),
    )
}
