@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAADIdentityProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Identity provider for MS AAD.
 * @property clientId The clientId password associated with the provider.
 * @property customerAdminGroupId The groupId to be granted cluster admin role.
 * @property kind The kind of the provider.
 * Expected value is 'AADIdentityProvider'.
 * @property secret The secret password associated with the provider.
 * @property tenantId The tenantId associated with the provider.
 */
public data class OpenShiftManagedClusterAADIdentityProviderArgs(
    public val clientId: Output<String>? = null,
    public val customerAdminGroupId: Output<String>? = null,
    public val kind: Output<String>,
    public val secret: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAADIdentityProviderArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAADIdentityProviderArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterAADIdentityProviderArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .customerAdminGroupId(customerAdminGroupId?.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 }))
            .secret(secret?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenShiftManagedClusterAADIdentityProviderArgs].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterAADIdentityProviderArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var customerAdminGroupId: Output<String>? = null

    private var kind: Output<String>? = null

    private var secret: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The clientId password associated with the provider.
     */
    @JvmName("uhgvccreiyngpnjv")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The groupId to be granted cluster admin role.
     */
    @JvmName("sqdycprijpsdxawl")
    public suspend fun customerAdminGroupId(`value`: Output<String>) {
        this.customerAdminGroupId = value
    }

    /**
     * @param value The kind of the provider.
     * Expected value is 'AADIdentityProvider'.
     */
    @JvmName("vksvijxeevydtulh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The secret password associated with the provider.
     */
    @JvmName("boylcbphlwwbundj")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value The tenantId associated with the provider.
     */
    @JvmName("kthklrctvvqddyga")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The clientId password associated with the provider.
     */
    @JvmName("rkrtkjtspnqcsxks")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The groupId to be granted cluster admin role.
     */
    @JvmName("yblspdinumdwvesm")
    public suspend fun customerAdminGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerAdminGroupId = mapped
    }

    /**
     * @param value The kind of the provider.
     * Expected value is 'AADIdentityProvider'.
     */
    @JvmName("dnbhureljcecvgth")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The secret password associated with the provider.
     */
    @JvmName("pryoacnlhebbksil")
    public suspend fun secret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param value The tenantId associated with the provider.
     */
    @JvmName("gjkdhuuoimuskqiv")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): OpenShiftManagedClusterAADIdentityProviderArgs =
        OpenShiftManagedClusterAADIdentityProviderArgs(
            clientId = clientId,
            customerAdminGroupId = customerAdminGroupId,
            kind = kind ?: throw PulumiNullFieldException("kind"),
            secret = secret,
            tenantId = tenantId,
        )
}
