@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterIdentityProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the configuration of the identity providers to be used in the OpenShift cluster.
 * @property name Name of the provider.
 * @property provider Configuration of the provider.
 */
public data class OpenShiftManagedClusterIdentityProviderArgs(
    public val name: Output<String>? = null,
    public val provider: Output<OpenShiftManagedClusterAADIdentityProviderArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterIdentityProviderArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterIdentityProviderArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterIdentityProviderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .provider(provider?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OpenShiftManagedClusterIdentityProviderArgs].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterIdentityProviderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var provider: Output<OpenShiftManagedClusterAADIdentityProviderArgs>? = null

    /**
     * @param value Name of the provider.
     */
    @JvmName("ludhkttxrmkfcwfo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration of the provider.
     */
    @JvmName("yndqcwajgshaqfym")
    public suspend fun provider(`value`: Output<OpenShiftManagedClusterAADIdentityProviderArgs>) {
        this.provider = value
    }

    /**
     * @param value Name of the provider.
     */
    @JvmName("regypkfepshkuygp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration of the provider.
     */
    @JvmName("gvtgbnxwmwlpdfux")
    public suspend fun provider(`value`: OpenShiftManagedClusterAADIdentityProviderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param argument Configuration of the provider.
     */
    @JvmName("gefbgbueffharnvj")
    public suspend
    fun provider(argument: suspend OpenShiftManagedClusterAADIdentityProviderArgsBuilder.() -> Unit) {
        val toBeMapped = OpenShiftManagedClusterAADIdentityProviderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.provider = mapped
    }

    internal fun build(): OpenShiftManagedClusterIdentityProviderArgs =
        OpenShiftManagedClusterIdentityProviderArgs(
            name = name,
            provider = provider,
        )
}
