@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.ConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The state of a private link service connection.
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val description: Output<String>? = null,
    public val status: Output<Either<String, ConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.containerservice.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var status: Output<Either<String, ConnectionStatus>>? = null

    /**
     * @param value The private link service connection description.
     */
    @JvmName("mxrtrfskpcrudfam")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("hwrubtkdpbwgmahd")
    public suspend fun status(`value`: Output<Either<String, ConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value The private link service connection description.
     */
    @JvmName("wppbwvhougvnoplv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("boxrsegnuyypjvrp")
    public suspend fun status(`value`: Either<String, ConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("gwmarddixntefepc")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("brsfbbeuqbdortrr")
    public fun status(`value`: ConnectionStatus) {
        val toBeMapped = Either.ofRight<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            description = description,
            status = status,
        )
}
