@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.SysctlConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sysctl settings for Linux agent nodes.
 * @property fsAioMaxNr Sysctl setting fs.aio-max-nr.
 * @property fsFileMax Sysctl setting fs.file-max.
 * @property fsInotifyMaxUserWatches Sysctl setting fs.inotify.max_user_watches.
 * @property fsNrOpen Sysctl setting fs.nr_open.
 * @property kernelThreadsMax Sysctl setting kernel.threads-max.
 * @property netCoreNetdevMaxBacklog Sysctl setting net.core.netdev_max_backlog.
 * @property netCoreOptmemMax Sysctl setting net.core.optmem_max.
 * @property netCoreRmemDefault Sysctl setting net.core.rmem_default.
 * @property netCoreRmemMax Sysctl setting net.core.rmem_max.
 * @property netCoreSomaxconn Sysctl setting net.core.somaxconn.
 * @property netCoreWmemDefault Sysctl setting net.core.wmem_default.
 * @property netCoreWmemMax Sysctl setting net.core.wmem_max.
 * @property netIpv4IpLocalPortRange Sysctl setting net.ipv4.ip_local_port_range.
 * @property netIpv4NeighDefaultGcThresh1 Sysctl setting net.ipv4.neigh.default.gc_thresh1.
 * @property netIpv4NeighDefaultGcThresh2 Sysctl setting net.ipv4.neigh.default.gc_thresh2.
 * @property netIpv4NeighDefaultGcThresh3 Sysctl setting net.ipv4.neigh.default.gc_thresh3.
 * @property netIpv4TcpFinTimeout Sysctl setting net.ipv4.tcp_fin_timeout.
 * @property netIpv4TcpKeepaliveProbes Sysctl setting net.ipv4.tcp_keepalive_probes.
 * @property netIpv4TcpKeepaliveTime Sysctl setting net.ipv4.tcp_keepalive_time.
 * @property netIpv4TcpMaxSynBacklog Sysctl setting net.ipv4.tcp_max_syn_backlog.
 * @property netIpv4TcpMaxTwBuckets Sysctl setting net.ipv4.tcp_max_tw_buckets.
 * @property netIpv4TcpTwReuse Sysctl setting net.ipv4.tcp_tw_reuse.
 * @property netIpv4TcpkeepaliveIntvl Sysctl setting net.ipv4.tcp_keepalive_intvl.
 * @property netNetfilterNfConntrackBuckets Sysctl setting net.netfilter.nf_conntrack_buckets.
 * @property netNetfilterNfConntrackMax Sysctl setting net.netfilter.nf_conntrack_max.
 * @property vmMaxMapCount Sysctl setting vm.max_map_count.
 * @property vmSwappiness Sysctl setting vm.swappiness.
 * @property vmVfsCachePressure Sysctl setting vm.vfs_cache_pressure.
 */
public data class SysctlConfigArgs(
    public val fsAioMaxNr: Output<Int>? = null,
    public val fsFileMax: Output<Int>? = null,
    public val fsInotifyMaxUserWatches: Output<Int>? = null,
    public val fsNrOpen: Output<Int>? = null,
    public val kernelThreadsMax: Output<Int>? = null,
    public val netCoreNetdevMaxBacklog: Output<Int>? = null,
    public val netCoreOptmemMax: Output<Int>? = null,
    public val netCoreRmemDefault: Output<Int>? = null,
    public val netCoreRmemMax: Output<Int>? = null,
    public val netCoreSomaxconn: Output<Int>? = null,
    public val netCoreWmemDefault: Output<Int>? = null,
    public val netCoreWmemMax: Output<Int>? = null,
    public val netIpv4IpLocalPortRange: Output<String>? = null,
    public val netIpv4NeighDefaultGcThresh1: Output<Int>? = null,
    public val netIpv4NeighDefaultGcThresh2: Output<Int>? = null,
    public val netIpv4NeighDefaultGcThresh3: Output<Int>? = null,
    public val netIpv4TcpFinTimeout: Output<Int>? = null,
    public val netIpv4TcpKeepaliveProbes: Output<Int>? = null,
    public val netIpv4TcpKeepaliveTime: Output<Int>? = null,
    public val netIpv4TcpMaxSynBacklog: Output<Int>? = null,
    public val netIpv4TcpMaxTwBuckets: Output<Int>? = null,
    public val netIpv4TcpTwReuse: Output<Boolean>? = null,
    public val netIpv4TcpkeepaliveIntvl: Output<Int>? = null,
    public val netNetfilterNfConntrackBuckets: Output<Int>? = null,
    public val netNetfilterNfConntrackMax: Output<Int>? = null,
    public val vmMaxMapCount: Output<Int>? = null,
    public val vmSwappiness: Output<Int>? = null,
    public val vmVfsCachePressure: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.SysctlConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.SysctlConfigArgs =
        com.pulumi.azurenative.containerservice.inputs.SysctlConfigArgs.builder()
            .fsAioMaxNr(fsAioMaxNr?.applyValue({ args0 -> args0 }))
            .fsFileMax(fsFileMax?.applyValue({ args0 -> args0 }))
            .fsInotifyMaxUserWatches(fsInotifyMaxUserWatches?.applyValue({ args0 -> args0 }))
            .fsNrOpen(fsNrOpen?.applyValue({ args0 -> args0 }))
            .kernelThreadsMax(kernelThreadsMax?.applyValue({ args0 -> args0 }))
            .netCoreNetdevMaxBacklog(netCoreNetdevMaxBacklog?.applyValue({ args0 -> args0 }))
            .netCoreOptmemMax(netCoreOptmemMax?.applyValue({ args0 -> args0 }))
            .netCoreRmemDefault(netCoreRmemDefault?.applyValue({ args0 -> args0 }))
            .netCoreRmemMax(netCoreRmemMax?.applyValue({ args0 -> args0 }))
            .netCoreSomaxconn(netCoreSomaxconn?.applyValue({ args0 -> args0 }))
            .netCoreWmemDefault(netCoreWmemDefault?.applyValue({ args0 -> args0 }))
            .netCoreWmemMax(netCoreWmemMax?.applyValue({ args0 -> args0 }))
            .netIpv4IpLocalPortRange(netIpv4IpLocalPortRange?.applyValue({ args0 -> args0 }))
            .netIpv4NeighDefaultGcThresh1(netIpv4NeighDefaultGcThresh1?.applyValue({ args0 -> args0 }))
            .netIpv4NeighDefaultGcThresh2(netIpv4NeighDefaultGcThresh2?.applyValue({ args0 -> args0 }))
            .netIpv4NeighDefaultGcThresh3(netIpv4NeighDefaultGcThresh3?.applyValue({ args0 -> args0 }))
            .netIpv4TcpFinTimeout(netIpv4TcpFinTimeout?.applyValue({ args0 -> args0 }))
            .netIpv4TcpKeepaliveProbes(netIpv4TcpKeepaliveProbes?.applyValue({ args0 -> args0 }))
            .netIpv4TcpKeepaliveTime(netIpv4TcpKeepaliveTime?.applyValue({ args0 -> args0 }))
            .netIpv4TcpMaxSynBacklog(netIpv4TcpMaxSynBacklog?.applyValue({ args0 -> args0 }))
            .netIpv4TcpMaxTwBuckets(netIpv4TcpMaxTwBuckets?.applyValue({ args0 -> args0 }))
            .netIpv4TcpTwReuse(netIpv4TcpTwReuse?.applyValue({ args0 -> args0 }))
            .netIpv4TcpkeepaliveIntvl(netIpv4TcpkeepaliveIntvl?.applyValue({ args0 -> args0 }))
            .netNetfilterNfConntrackBuckets(netNetfilterNfConntrackBuckets?.applyValue({ args0 -> args0 }))
            .netNetfilterNfConntrackMax(netNetfilterNfConntrackMax?.applyValue({ args0 -> args0 }))
            .vmMaxMapCount(vmMaxMapCount?.applyValue({ args0 -> args0 }))
            .vmSwappiness(vmSwappiness?.applyValue({ args0 -> args0 }))
            .vmVfsCachePressure(vmVfsCachePressure?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SysctlConfigArgs].
 */
@PulumiTagMarker
public class SysctlConfigArgsBuilder internal constructor() {
    private var fsAioMaxNr: Output<Int>? = null

    private var fsFileMax: Output<Int>? = null

    private var fsInotifyMaxUserWatches: Output<Int>? = null

    private var fsNrOpen: Output<Int>? = null

    private var kernelThreadsMax: Output<Int>? = null

    private var netCoreNetdevMaxBacklog: Output<Int>? = null

    private var netCoreOptmemMax: Output<Int>? = null

    private var netCoreRmemDefault: Output<Int>? = null

    private var netCoreRmemMax: Output<Int>? = null

    private var netCoreSomaxconn: Output<Int>? = null

    private var netCoreWmemDefault: Output<Int>? = null

    private var netCoreWmemMax: Output<Int>? = null

    private var netIpv4IpLocalPortRange: Output<String>? = null

    private var netIpv4NeighDefaultGcThresh1: Output<Int>? = null

    private var netIpv4NeighDefaultGcThresh2: Output<Int>? = null

    private var netIpv4NeighDefaultGcThresh3: Output<Int>? = null

    private var netIpv4TcpFinTimeout: Output<Int>? = null

    private var netIpv4TcpKeepaliveProbes: Output<Int>? = null

    private var netIpv4TcpKeepaliveTime: Output<Int>? = null

    private var netIpv4TcpMaxSynBacklog: Output<Int>? = null

    private var netIpv4TcpMaxTwBuckets: Output<Int>? = null

    private var netIpv4TcpTwReuse: Output<Boolean>? = null

    private var netIpv4TcpkeepaliveIntvl: Output<Int>? = null

    private var netNetfilterNfConntrackBuckets: Output<Int>? = null

    private var netNetfilterNfConntrackMax: Output<Int>? = null

    private var vmMaxMapCount: Output<Int>? = null

    private var vmSwappiness: Output<Int>? = null

    private var vmVfsCachePressure: Output<Int>? = null

    /**
     * @param value Sysctl setting fs.aio-max-nr.
     */
    @JvmName("mmlodyuxdpelqjnb")
    public suspend fun fsAioMaxNr(`value`: Output<Int>) {
        this.fsAioMaxNr = value
    }

    /**
     * @param value Sysctl setting fs.file-max.
     */
    @JvmName("jtxuehvukyrlrklh")
    public suspend fun fsFileMax(`value`: Output<Int>) {
        this.fsFileMax = value
    }

    /**
     * @param value Sysctl setting fs.inotify.max_user_watches.
     */
    @JvmName("fmprfvpktcvxyrnp")
    public suspend fun fsInotifyMaxUserWatches(`value`: Output<Int>) {
        this.fsInotifyMaxUserWatches = value
    }

    /**
     * @param value Sysctl setting fs.nr_open.
     */
    @JvmName("ittrjlfmsrsxojsm")
    public suspend fun fsNrOpen(`value`: Output<Int>) {
        this.fsNrOpen = value
    }

    /**
     * @param value Sysctl setting kernel.threads-max.
     */
    @JvmName("mafgfacuefhmqdqw")
    public suspend fun kernelThreadsMax(`value`: Output<Int>) {
        this.kernelThreadsMax = value
    }

    /**
     * @param value Sysctl setting net.core.netdev_max_backlog.
     */
    @JvmName("pvfwkwcbhcvivvcd")
    public suspend fun netCoreNetdevMaxBacklog(`value`: Output<Int>) {
        this.netCoreNetdevMaxBacklog = value
    }

    /**
     * @param value Sysctl setting net.core.optmem_max.
     */
    @JvmName("pmvppahxvrqqgwni")
    public suspend fun netCoreOptmemMax(`value`: Output<Int>) {
        this.netCoreOptmemMax = value
    }

    /**
     * @param value Sysctl setting net.core.rmem_default.
     */
    @JvmName("hcrqxvsthpeubcnc")
    public suspend fun netCoreRmemDefault(`value`: Output<Int>) {
        this.netCoreRmemDefault = value
    }

    /**
     * @param value Sysctl setting net.core.rmem_max.
     */
    @JvmName("nkjuwcswbvfbnkwk")
    public suspend fun netCoreRmemMax(`value`: Output<Int>) {
        this.netCoreRmemMax = value
    }

    /**
     * @param value Sysctl setting net.core.somaxconn.
     */
    @JvmName("jinhccycxjumkali")
    public suspend fun netCoreSomaxconn(`value`: Output<Int>) {
        this.netCoreSomaxconn = value
    }

    /**
     * @param value Sysctl setting net.core.wmem_default.
     */
    @JvmName("ppimenhhsbklibdx")
    public suspend fun netCoreWmemDefault(`value`: Output<Int>) {
        this.netCoreWmemDefault = value
    }

    /**
     * @param value Sysctl setting net.core.wmem_max.
     */
    @JvmName("vdhnpwodetgwyjnc")
    public suspend fun netCoreWmemMax(`value`: Output<Int>) {
        this.netCoreWmemMax = value
    }

    /**
     * @param value Sysctl setting net.ipv4.ip_local_port_range.
     */
    @JvmName("leggubjwmchxluqn")
    public suspend fun netIpv4IpLocalPortRange(`value`: Output<String>) {
        this.netIpv4IpLocalPortRange = value
    }

    /**
     * @param value Sysctl setting net.ipv4.neigh.default.gc_thresh1.
     */
    @JvmName("iwlstgmjxjmtqthj")
    public suspend fun netIpv4NeighDefaultGcThresh1(`value`: Output<Int>) {
        this.netIpv4NeighDefaultGcThresh1 = value
    }

    /**
     * @param value Sysctl setting net.ipv4.neigh.default.gc_thresh2.
     */
    @JvmName("xuhuvdlblhbdoyei")
    public suspend fun netIpv4NeighDefaultGcThresh2(`value`: Output<Int>) {
        this.netIpv4NeighDefaultGcThresh2 = value
    }

    /**
     * @param value Sysctl setting net.ipv4.neigh.default.gc_thresh3.
     */
    @JvmName("hotmewjcurshxtqp")
    public suspend fun netIpv4NeighDefaultGcThresh3(`value`: Output<Int>) {
        this.netIpv4NeighDefaultGcThresh3 = value
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_fin_timeout.
     */
    @JvmName("soyaeexecqgagshh")
    public suspend fun netIpv4TcpFinTimeout(`value`: Output<Int>) {
        this.netIpv4TcpFinTimeout = value
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_keepalive_probes.
     */
    @JvmName("xijlibkherjldswd")
    public suspend fun netIpv4TcpKeepaliveProbes(`value`: Output<Int>) {
        this.netIpv4TcpKeepaliveProbes = value
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_keepalive_time.
     */
    @JvmName("yeiwvabpnleodnnd")
    public suspend fun netIpv4TcpKeepaliveTime(`value`: Output<Int>) {
        this.netIpv4TcpKeepaliveTime = value
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_max_syn_backlog.
     */
    @JvmName("pxireffoaxdvnsth")
    public suspend fun netIpv4TcpMaxSynBacklog(`value`: Output<Int>) {
        this.netIpv4TcpMaxSynBacklog = value
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_max_tw_buckets.
     */
    @JvmName("kbdpkdydcaynpeaf")
    public suspend fun netIpv4TcpMaxTwBuckets(`value`: Output<Int>) {
        this.netIpv4TcpMaxTwBuckets = value
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_tw_reuse.
     */
    @JvmName("uivrslmivhtsrawh")
    public suspend fun netIpv4TcpTwReuse(`value`: Output<Boolean>) {
        this.netIpv4TcpTwReuse = value
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_keepalive_intvl.
     */
    @JvmName("wxyjnitamptnknsh")
    public suspend fun netIpv4TcpkeepaliveIntvl(`value`: Output<Int>) {
        this.netIpv4TcpkeepaliveIntvl = value
    }

    /**
     * @param value Sysctl setting net.netfilter.nf_conntrack_buckets.
     */
    @JvmName("jqqtbrukfcpnkatn")
    public suspend fun netNetfilterNfConntrackBuckets(`value`: Output<Int>) {
        this.netNetfilterNfConntrackBuckets = value
    }

    /**
     * @param value Sysctl setting net.netfilter.nf_conntrack_max.
     */
    @JvmName("eyoedfkwjyjuqfxj")
    public suspend fun netNetfilterNfConntrackMax(`value`: Output<Int>) {
        this.netNetfilterNfConntrackMax = value
    }

    /**
     * @param value Sysctl setting vm.max_map_count.
     */
    @JvmName("jvdqfqjijqejuqrl")
    public suspend fun vmMaxMapCount(`value`: Output<Int>) {
        this.vmMaxMapCount = value
    }

    /**
     * @param value Sysctl setting vm.swappiness.
     */
    @JvmName("hinexutwysbinkpf")
    public suspend fun vmSwappiness(`value`: Output<Int>) {
        this.vmSwappiness = value
    }

    /**
     * @param value Sysctl setting vm.vfs_cache_pressure.
     */
    @JvmName("pomktgxgheqjlhrp")
    public suspend fun vmVfsCachePressure(`value`: Output<Int>) {
        this.vmVfsCachePressure = value
    }

    /**
     * @param value Sysctl setting fs.aio-max-nr.
     */
    @JvmName("ehwyxvqsjorbdots")
    public suspend fun fsAioMaxNr(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsAioMaxNr = mapped
    }

    /**
     * @param value Sysctl setting fs.file-max.
     */
    @JvmName("gxhgfqfhboufgnkh")
    public suspend fun fsFileMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsFileMax = mapped
    }

    /**
     * @param value Sysctl setting fs.inotify.max_user_watches.
     */
    @JvmName("hbhvfpcqtjqjxjsl")
    public suspend fun fsInotifyMaxUserWatches(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsInotifyMaxUserWatches = mapped
    }

    /**
     * @param value Sysctl setting fs.nr_open.
     */
    @JvmName("ckeigktbvxpbdoua")
    public suspend fun fsNrOpen(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsNrOpen = mapped
    }

    /**
     * @param value Sysctl setting kernel.threads-max.
     */
    @JvmName("iwjnqttgixeofaxb")
    public suspend fun kernelThreadsMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelThreadsMax = mapped
    }

    /**
     * @param value Sysctl setting net.core.netdev_max_backlog.
     */
    @JvmName("hspxlddyaaqmuxex")
    public suspend fun netCoreNetdevMaxBacklog(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreNetdevMaxBacklog = mapped
    }

    /**
     * @param value Sysctl setting net.core.optmem_max.
     */
    @JvmName("jyuoiqnjoftxdnns")
    public suspend fun netCoreOptmemMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreOptmemMax = mapped
    }

    /**
     * @param value Sysctl setting net.core.rmem_default.
     */
    @JvmName("xcgfojowgmqbbtyi")
    public suspend fun netCoreRmemDefault(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreRmemDefault = mapped
    }

    /**
     * @param value Sysctl setting net.core.rmem_max.
     */
    @JvmName("tmdsrhadrhwcjndi")
    public suspend fun netCoreRmemMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreRmemMax = mapped
    }

    /**
     * @param value Sysctl setting net.core.somaxconn.
     */
    @JvmName("wwemmwssnjlklrdw")
    public suspend fun netCoreSomaxconn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreSomaxconn = mapped
    }

    /**
     * @param value Sysctl setting net.core.wmem_default.
     */
    @JvmName("inwssfodtdordwcf")
    public suspend fun netCoreWmemDefault(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreWmemDefault = mapped
    }

    /**
     * @param value Sysctl setting net.core.wmem_max.
     */
    @JvmName("mwaskdfijdcfngcn")
    public suspend fun netCoreWmemMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netCoreWmemMax = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.ip_local_port_range.
     */
    @JvmName("vqhmfiuwuwapnlde")
    public suspend fun netIpv4IpLocalPortRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4IpLocalPortRange = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.neigh.default.gc_thresh1.
     */
    @JvmName("wdbxntgfkkxitwkh")
    public suspend fun netIpv4NeighDefaultGcThresh1(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4NeighDefaultGcThresh1 = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.neigh.default.gc_thresh2.
     */
    @JvmName("biwiblphxnxjurpn")
    public suspend fun netIpv4NeighDefaultGcThresh2(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4NeighDefaultGcThresh2 = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.neigh.default.gc_thresh3.
     */
    @JvmName("qhaduvpcsgyihfvi")
    public suspend fun netIpv4NeighDefaultGcThresh3(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4NeighDefaultGcThresh3 = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_fin_timeout.
     */
    @JvmName("kqnskevdcphxlwuu")
    public suspend fun netIpv4TcpFinTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4TcpFinTimeout = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_keepalive_probes.
     */
    @JvmName("bmohjgtpvrxvddau")
    public suspend fun netIpv4TcpKeepaliveProbes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4TcpKeepaliveProbes = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_keepalive_time.
     */
    @JvmName("hsgejycmrnxdtpfv")
    public suspend fun netIpv4TcpKeepaliveTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4TcpKeepaliveTime = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_max_syn_backlog.
     */
    @JvmName("txmrtrqpmnmkkakq")
    public suspend fun netIpv4TcpMaxSynBacklog(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4TcpMaxSynBacklog = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_max_tw_buckets.
     */
    @JvmName("dhhtjigxmdjmvcgs")
    public suspend fun netIpv4TcpMaxTwBuckets(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4TcpMaxTwBuckets = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_tw_reuse.
     */
    @JvmName("yggcosdrlhymmbis")
    public suspend fun netIpv4TcpTwReuse(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4TcpTwReuse = mapped
    }

    /**
     * @param value Sysctl setting net.ipv4.tcp_keepalive_intvl.
     */
    @JvmName("ohpauxmumkqumhfy")
    public suspend fun netIpv4TcpkeepaliveIntvl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netIpv4TcpkeepaliveIntvl = mapped
    }

    /**
     * @param value Sysctl setting net.netfilter.nf_conntrack_buckets.
     */
    @JvmName("yoryvfmcfpaescxn")
    public suspend fun netNetfilterNfConntrackBuckets(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netNetfilterNfConntrackBuckets = mapped
    }

    /**
     * @param value Sysctl setting net.netfilter.nf_conntrack_max.
     */
    @JvmName("qmqfovhtoloadlku")
    public suspend fun netNetfilterNfConntrackMax(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netNetfilterNfConntrackMax = mapped
    }

    /**
     * @param value Sysctl setting vm.max_map_count.
     */
    @JvmName("jeajxuhaoskttlgj")
    public suspend fun vmMaxMapCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmMaxMapCount = mapped
    }

    /**
     * @param value Sysctl setting vm.swappiness.
     */
    @JvmName("cndjsdosarfuvgwp")
    public suspend fun vmSwappiness(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSwappiness = mapped
    }

    /**
     * @param value Sysctl setting vm.vfs_cache_pressure.
     */
    @JvmName("nrdqhkxlaftgibeo")
    public suspend fun vmVfsCachePressure(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmVfsCachePressure = mapped
    }

    internal fun build(): SysctlConfigArgs = SysctlConfigArgs(
        fsAioMaxNr = fsAioMaxNr,
        fsFileMax = fsFileMax,
        fsInotifyMaxUserWatches = fsInotifyMaxUserWatches,
        fsNrOpen = fsNrOpen,
        kernelThreadsMax = kernelThreadsMax,
        netCoreNetdevMaxBacklog = netCoreNetdevMaxBacklog,
        netCoreOptmemMax = netCoreOptmemMax,
        netCoreRmemDefault = netCoreRmemDefault,
        netCoreRmemMax = netCoreRmemMax,
        netCoreSomaxconn = netCoreSomaxconn,
        netCoreWmemDefault = netCoreWmemDefault,
        netCoreWmemMax = netCoreWmemMax,
        netIpv4IpLocalPortRange = netIpv4IpLocalPortRange,
        netIpv4NeighDefaultGcThresh1 = netIpv4NeighDefaultGcThresh1,
        netIpv4NeighDefaultGcThresh2 = netIpv4NeighDefaultGcThresh2,
        netIpv4NeighDefaultGcThresh3 = netIpv4NeighDefaultGcThresh3,
        netIpv4TcpFinTimeout = netIpv4TcpFinTimeout,
        netIpv4TcpKeepaliveProbes = netIpv4TcpKeepaliveProbes,
        netIpv4TcpKeepaliveTime = netIpv4TcpKeepaliveTime,
        netIpv4TcpMaxSynBacklog = netIpv4TcpMaxSynBacklog,
        netIpv4TcpMaxTwBuckets = netIpv4TcpMaxTwBuckets,
        netIpv4TcpTwReuse = netIpv4TcpTwReuse,
        netIpv4TcpkeepaliveIntvl = netIpv4TcpkeepaliveIntvl,
        netNetfilterNfConntrackBuckets = netNetfilterNfConntrackBuckets,
        netNetfilterNfConntrackMax = netNetfilterNfConntrackMax,
        vmMaxMapCount = vmMaxMapCount,
        vmSwappiness = vmSwappiness,
        vmVfsCachePressure = vmVfsCachePressure,
    )
}
