@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.TimeSpanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * For example, between 2021-05-25T13:00:00Z and 2021-05-25T14:00:00Z.
 * @property end The end of a time span
 * @property start The start of a time span
 */
public data class TimeSpanArgs(
    public val end: Output<String>? = null,
    public val start: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.TimeSpanArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.TimeSpanArgs =
        com.pulumi.azurenative.containerservice.inputs.TimeSpanArgs.builder()
            .end(end?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TimeSpanArgs].
 */
@PulumiTagMarker
public class TimeSpanArgsBuilder internal constructor() {
    private var end: Output<String>? = null

    private var start: Output<String>? = null

    /**
     * @param value The end of a time span
     */
    @JvmName("wdmdcgtbilipgoff")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value The start of a time span
     */
    @JvmName("cumjplrjbfvnjnoa")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value The end of a time span
     */
    @JvmName("ujctcoltmhsgbyyh")
    public suspend fun end(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value The start of a time span
     */
    @JvmName("yclefdghijkakisu")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): TimeSpanArgs = TimeSpanArgs(
        end = end,
        start = start,
    )
}
