@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Desired outbound IP Prefix resources for the cluster load balancer.
 * @property publicIPPrefixes A list of public IP prefix resources.
 */
public data class ManagedClusterLoadBalancerProfileResponseOutboundIPPrefixes(
    public val publicIPPrefixes: List<ResourceReferenceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterLoadBalancerProfileResponseOutboundIPPrefixes):
            ManagedClusterLoadBalancerProfileResponseOutboundIPPrefixes =
            ManagedClusterLoadBalancerProfileResponseOutboundIPPrefixes(
                publicIPPrefixes = javaType.publicIPPrefixes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
