@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Parameters to be applied to the cluster-autoscaler when enabled
 * @property balanceSimilarNodeGroups Valid values are 'true' and 'false'
 * @property expander If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
 * @property maxEmptyBulkDelete The default is 10.
 * @property maxGracefulTerminationSec The default is 600.
 * @property maxNodeProvisionTime The default is '15m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property maxTotalUnreadyPercentage The default is 45. The maximum is 100 and the minimum is 0.
 * @property newPodScaleUpDelay For scenarios like burst/batch scale where you don't want CA to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
 * @property okTotalUnreadyCount This must be an integer. The default is 3.
 * @property scaleDownDelayAfterAdd The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownDelayAfterDelete The default is the scan-interval. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownDelayAfterFailure The default is '3m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownUnneededTime The default is '10m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownUnreadyTime The default is '20m'. Values must be an integer followed by an 'm'. No unit of time other than minutes (m) is supported.
 * @property scaleDownUtilizationThreshold The default is '0.5'.
 * @property scanInterval The default is '10'. Values must be an integer number of seconds.
 * @property skipNodesWithLocalStorage The default is true.
 * @property skipNodesWithSystemPods The default is true.
 */
public data class ManagedClusterPropertiesResponseAutoScalerProfile(
    public val balanceSimilarNodeGroups: String? = null,
    public val expander: String? = null,
    public val maxEmptyBulkDelete: String? = null,
    public val maxGracefulTerminationSec: String? = null,
    public val maxNodeProvisionTime: String? = null,
    public val maxTotalUnreadyPercentage: String? = null,
    public val newPodScaleUpDelay: String? = null,
    public val okTotalUnreadyCount: String? = null,
    public val scaleDownDelayAfterAdd: String? = null,
    public val scaleDownDelayAfterDelete: String? = null,
    public val scaleDownDelayAfterFailure: String? = null,
    public val scaleDownUnneededTime: String? = null,
    public val scaleDownUnreadyTime: String? = null,
    public val scaleDownUtilizationThreshold: String? = null,
    public val scanInterval: String? = null,
    public val skipNodesWithLocalStorage: String? = null,
    public val skipNodesWithSystemPods: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterPropertiesResponseAutoScalerProfile):
            ManagedClusterPropertiesResponseAutoScalerProfile =
            ManagedClusterPropertiesResponseAutoScalerProfile(
                balanceSimilarNodeGroups = javaType.balanceSimilarNodeGroups().map({ args0 -> args0 }).orElse(null),
                expander = javaType.expander().map({ args0 -> args0 }).orElse(null),
                maxEmptyBulkDelete = javaType.maxEmptyBulkDelete().map({ args0 -> args0 }).orElse(null),
                maxGracefulTerminationSec = javaType.maxGracefulTerminationSec().map({ args0 ->
                    args0
                }).orElse(null),
                maxNodeProvisionTime = javaType.maxNodeProvisionTime().map({ args0 -> args0 }).orElse(null),
                maxTotalUnreadyPercentage = javaType.maxTotalUnreadyPercentage().map({ args0 ->
                    args0
                }).orElse(null),
                newPodScaleUpDelay = javaType.newPodScaleUpDelay().map({ args0 -> args0 }).orElse(null),
                okTotalUnreadyCount = javaType.okTotalUnreadyCount().map({ args0 -> args0 }).orElse(null),
                scaleDownDelayAfterAdd = javaType.scaleDownDelayAfterAdd().map({ args0 -> args0 }).orElse(null),
                scaleDownDelayAfterDelete = javaType.scaleDownDelayAfterDelete().map({ args0 ->
                    args0
                }).orElse(null),
                scaleDownDelayAfterFailure = javaType.scaleDownDelayAfterFailure().map({ args0 ->
                    args0
                }).orElse(null),
                scaleDownUnneededTime = javaType.scaleDownUnneededTime().map({ args0 -> args0 }).orElse(null),
                scaleDownUnreadyTime = javaType.scaleDownUnreadyTime().map({ args0 -> args0 }).orElse(null),
                scaleDownUtilizationThreshold = javaType.scaleDownUtilizationThreshold().map({ args0 ->
                    args0
                }).orElse(null),
                scanInterval = javaType.scanInterval().map({ args0 -> args0 }).orElse(null),
                skipNodesWithLocalStorage = javaType.skipNodesWithLocalStorage().map({ args0 ->
                    args0
                }).orElse(null),
                skipNodesWithSystemPods = javaType.skipNodesWithSystemPods().map({ args0 -> args0 }).orElse(null),
            )
    }
}
