@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines the configuration of the OpenShift cluster VMs.
 * @property count Number of agents (VMs) to host docker containers.
 * @property name Unique name of the pool profile in the context of the subscription and resource group.
 * @property osType OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
 * @property role Define the role of the AgentPoolProfile.
 * @property subnetCidr Subnet CIDR for the peering.
 * @property vmSize Size of agent VMs.
 */
public data class OpenShiftManagedClusterAgentPoolProfileResponse(
    public val count: Int,
    public val name: String,
    public val osType: String? = null,
    public val role: String? = null,
    public val subnetCidr: String? = null,
    public val vmSize: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftManagedClusterAgentPoolProfileResponse):
            OpenShiftManagedClusterAgentPoolProfileResponse =
            OpenShiftManagedClusterAgentPoolProfileResponse(
                count = javaType.count(),
                name = javaType.name(),
                osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
                role = javaType.role().map({ args0 -> args0 }).orElse(null),
                subnetCidr = javaType.subnetCidr().map({ args0 -> args0 }).orElse(null),
                vmSize = javaType.vmSize(),
            )
    }
}
