@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Defines the configuration for Log Analytics integration.
 * @property enabled If the Log analytics integration should be turned on or off
 * @property workspaceResourceID Azure Resource Manager Resource ID for the Log Analytics workspace to integrate with.
 */
public data class OpenShiftManagedClusterMonitorProfileResponse(
    public val enabled: Boolean? = null,
    public val workspaceResourceID: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftManagedClusterMonitorProfileResponse):
            OpenShiftManagedClusterMonitorProfileResponse =
            OpenShiftManagedClusterMonitorProfileResponse(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                workspaceResourceID = javaType.workspaceResourceID().map({ args0 -> args0 }).orElse(null),
            )
    }
}
