@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The status of a UpdateRun.
 * @property stages The stages composing an update run. Stages are run sequentially withing an UpdateRun.
 * @property status The status of the UpdateRun.
 */
public data class UpdateRunStatusResponse(
    public val stages: List<UpdateStageStatusResponse>,
    public val status: UpdateStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.UpdateRunStatusResponse):
            UpdateRunStatusResponse = UpdateRunStatusResponse(
            stages = javaType.stages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateStageStatusResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
